<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetGenericArchiveByPeriodRequest StructType
 * Meta informations extracted from the WSDL
 * - type: GetGenericArchiveByPeriodRequest
 * @subpackage Structs
 */
class GetGenericArchiveByPeriodRequest extends AbstractStructBase
{
    /**
     * The DONEM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DONEM;
    /**
     * The VKN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VKN;
    /**
     * The REQUEST_HEADER
     * @var \StructType\REQUEST_HEADERType
     */
    public $REQUEST_HEADER;
    /**
     * Constructor method for GetGenericArchiveByPeriodRequest
     * @uses GetGenericArchiveByPeriodRequest::setDONEM()
     * @uses GetGenericArchiveByPeriodRequest::setVKN()
     * @uses GetGenericArchiveByPeriodRequest::setREQUEST_HEADER()
     * @param string $dONEM
     * @param string $vKN
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     */
    public function __construct($dONEM = null, $vKN = null, \StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this
            ->setDONEM($dONEM)
            ->setVKN($vKN)
            ->setREQUEST_HEADER($rEQUEST_HEADER);
    }
    /**
     * Get DONEM value
     * @return string
     */
    public function getDONEM()
    {
        return $this->DONEM;
    }
    /**
     * Set DONEM value
     * @param string $dONEM
     * @return \StructType\GetGenericArchiveByPeriodRequest
     */
    public function setDONEM($dONEM = null)
    {
        // validation for constraint: string
        if (!is_null($dONEM) && !is_string($dONEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dONEM)), __LINE__);
        }
        $this->DONEM = $dONEM;
        return $this;
    }
    /**
     * Get VKN value
     * @return string
     */
    public function getVKN()
    {
        return $this->VKN;
    }
    /**
     * Set VKN value
     * @param string $vKN
     * @return \StructType\GetGenericArchiveByPeriodRequest
     */
    public function setVKN($vKN = null)
    {
        // validation for constraint: string
        if (!is_null($vKN) && !is_string($vKN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vKN)), __LINE__);
        }
        $this->VKN = $vKN;
        return $this;
    }
    /**
     * Get REQUEST_HEADER value
     * @return \StructType\REQUEST_HEADERType|null
     */
    public function getREQUEST_HEADER()
    {
        return $this->REQUEST_HEADER;
    }
    /**
     * Set REQUEST_HEADER value
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @return \StructType\GetGenericArchiveByPeriodRequest
     */
    public function setREQUEST_HEADER(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this->REQUEST_HEADER = $rEQUEST_HEADER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetGenericArchiveByPeriodRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
