<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEArchiveInvoiceStatusRequest StructType
 * Meta informations extracted from the WSDL
 * - type: GetEArchiveInvoiceStatusRequest
 * @subpackage Structs
 */
class GetEArchiveInvoiceStatusRequest extends AbstractStructBase
{
    /**
     * The UUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 500
     * - minOccurs: 1
     * @var string[]
     */
    public $UUID;
    /**
     * The REQUEST_HEADER
     * @var \StructType\REQUEST_HEADERType
     */
    public $REQUEST_HEADER;
    /**
     * Constructor method for GetEArchiveInvoiceStatusRequest
     * @uses GetEArchiveInvoiceStatusRequest::setUUID()
     * @uses GetEArchiveInvoiceStatusRequest::setREQUEST_HEADER()
     * @param string[] $uUID
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     */
    public function __construct(array $uUID = array(), \StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this
            ->setUUID($uUID)
            ->setREQUEST_HEADER($rEQUEST_HEADER);
    }
    /**
     * Get UUID value
     * @return string[]
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @throws \InvalidArgumentException
     * @param string[] $uUID
     * @return \StructType\GetEArchiveInvoiceStatusRequest
     */
    public function setUUID(array $uUID = array())
    {
        foreach ($uUID as $getEArchiveInvoiceStatusRequestUUIDItem) {
            // validation for constraint: itemType
            if (!is_string($getEArchiveInvoiceStatusRequestUUIDItem)) {
                throw new \InvalidArgumentException(sprintf('The UUID property can only contain items of string, "%s" given', is_object($getEArchiveInvoiceStatusRequestUUIDItem) ? get_class($getEArchiveInvoiceStatusRequestUUIDItem) : gettype($getEArchiveInvoiceStatusRequestUUIDItem)), __LINE__);
            }
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Add item to UUID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetEArchiveInvoiceStatusRequest
     */
    public function addToUUID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The UUID property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UUID[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_HEADER value
     * @return \StructType\REQUEST_HEADERType|null
     */
    public function getREQUEST_HEADER()
    {
        return $this->REQUEST_HEADER;
    }
    /**
     * Set REQUEST_HEADER value
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @return \StructType\GetEArchiveInvoiceStatusRequest
     */
    public function setREQUEST_HEADER(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this->REQUEST_HEADER = $rEQUEST_HEADER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEArchiveInvoiceStatusRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
