<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EARSIV_PROPERTIES StructType
 * @subpackage Structs
 */
class EARSIV_PROPERTIES extends AbstractStructBase
{
    /**
     * The EARSIV_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $EARSIV_TYPE;
    /**
     * The EARSIV_EMAIL_FLAG
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $EARSIV_EMAIL_FLAG;
    /**
     * The EARSIV_EMAIL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $EARSIV_EMAIL;
    /**
     * The SUB_STATUS
     * Meta informations extracted from the WSDL
     * - default: NEW
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SUB_STATUS;
    /**
     * The ARCH_INVOICE_ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ARCH_INVOICE_ID;
    /**
     * The SERI
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SERI;
    /**
     * The EARCHIVE_TEST_FLAG
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EARCHIVE_TEST_FLAG;
    /**
     * The EARSIV_SMS_FLAG
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EARSIV_SMS_FLAG;
    /**
     * The SMS_PHONE_NUMBER
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SMS_PHONE_NUMBER;
    /**
     * Constructor method for EARSIV_PROPERTIES
     * @uses EARSIV_PROPERTIES::setEARSIV_TYPE()
     * @uses EARSIV_PROPERTIES::setEARSIV_EMAIL_FLAG()
     * @uses EARSIV_PROPERTIES::setEARSIV_EMAIL()
     * @uses EARSIV_PROPERTIES::setSUB_STATUS()
     * @uses EARSIV_PROPERTIES::setARCH_INVOICE_ID()
     * @uses EARSIV_PROPERTIES::setSERI()
     * @uses EARSIV_PROPERTIES::setEARCHIVE_TEST_FLAG()
     * @uses EARSIV_PROPERTIES::setEARSIV_SMS_FLAG()
     * @uses EARSIV_PROPERTIES::setSMS_PHONE_NUMBER()
     * @param string $eARSIV_TYPE
     * @param string $eARSIV_EMAIL_FLAG
     * @param string[] $eARSIV_EMAIL
     * @param string $sUB_STATUS
     * @param int $aRCH_INVOICE_ID
     * @param string $sERI
     * @param string $eARCHIVE_TEST_FLAG
     * @param string $eARSIV_SMS_FLAG
     * @param string $sMS_PHONE_NUMBER
     */
    public function __construct($eARSIV_TYPE = null, $eARSIV_EMAIL_FLAG = 'N', array $eARSIV_EMAIL = array(), $sUB_STATUS = 'NEW', $aRCH_INVOICE_ID = null, $sERI = null, $eARCHIVE_TEST_FLAG = null, $eARSIV_SMS_FLAG = null, $sMS_PHONE_NUMBER = null)
    {
        $this
            ->setEARSIV_TYPE($eARSIV_TYPE)
            ->setEARSIV_EMAIL_FLAG($eARSIV_EMAIL_FLAG)
            ->setEARSIV_EMAIL($eARSIV_EMAIL)
            ->setSUB_STATUS($sUB_STATUS)
            ->setARCH_INVOICE_ID($aRCH_INVOICE_ID)
            ->setSERI($sERI)
            ->setEARCHIVE_TEST_FLAG($eARCHIVE_TEST_FLAG)
            ->setEARSIV_SMS_FLAG($eARSIV_SMS_FLAG)
            ->setSMS_PHONE_NUMBER($sMS_PHONE_NUMBER);
    }
    /**
     * Get EARSIV_TYPE value
     * @return string
     */
    public function getEARSIV_TYPE()
    {
        return $this->EARSIV_TYPE;
    }
    /**
     * Set EARSIV_TYPE value
     * @uses \EnumType\EARSIV_TYPE_VALUE::valueIsValid()
     * @uses \EnumType\EARSIV_TYPE_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eARSIV_TYPE
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setEARSIV_TYPE($eARSIV_TYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EARSIV_TYPE_VALUE::valueIsValid($eARSIV_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eARSIV_TYPE, implode(', ', \EnumType\EARSIV_TYPE_VALUE::getValidValues())), __LINE__);
        }
        $this->EARSIV_TYPE = $eARSIV_TYPE;
        return $this;
    }
    /**
     * Get EARSIV_EMAIL_FLAG value
     * @return string|null
     */
    public function getEARSIV_EMAIL_FLAG()
    {
        return $this->EARSIV_EMAIL_FLAG;
    }
    /**
     * Set EARSIV_EMAIL_FLAG value
     * @uses \EnumType\FLAG_VALUE::valueIsValid()
     * @uses \EnumType\FLAG_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eARSIV_EMAIL_FLAG
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setEARSIV_EMAIL_FLAG($eARSIV_EMAIL_FLAG = 'N')
    {
        // validation for constraint: enumeration
        if (!\EnumType\FLAG_VALUE::valueIsValid($eARSIV_EMAIL_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eARSIV_EMAIL_FLAG, implode(', ', \EnumType\FLAG_VALUE::getValidValues())), __LINE__);
        }
        $this->EARSIV_EMAIL_FLAG = $eARSIV_EMAIL_FLAG;
        return $this;
    }
    /**
     * Get EARSIV_EMAIL value
     * @return string[]|null
     */
    public function getEARSIV_EMAIL()
    {
        return $this->EARSIV_EMAIL;
    }
    /**
     * Set EARSIV_EMAIL value
     * @throws \InvalidArgumentException
     * @param string[] $eARSIV_EMAIL
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setEARSIV_EMAIL(array $eARSIV_EMAIL = array())
    {
        foreach ($eARSIV_EMAIL as $eARSIV_PROPERTIESEARSIV_EMAILItem) {
            // validation for constraint: itemType
            if (!is_string($eARSIV_PROPERTIESEARSIV_EMAILItem)) {
                throw new \InvalidArgumentException(sprintf('The EARSIV_EMAIL property can only contain items of string, "%s" given', is_object($eARSIV_PROPERTIESEARSIV_EMAILItem) ? get_class($eARSIV_PROPERTIESEARSIV_EMAILItem) : gettype($eARSIV_PROPERTIESEARSIV_EMAILItem)), __LINE__);
            }
        }
        $this->EARSIV_EMAIL = $eARSIV_EMAIL;
        return $this;
    }
    /**
     * Add item to EARSIV_EMAIL value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function addToEARSIV_EMAIL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The EARSIV_EMAIL property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EARSIV_EMAIL[] = $item;
        return $this;
    }
    /**
     * Get SUB_STATUS value
     * @return string|null
     */
    public function getSUB_STATUS()
    {
        return $this->SUB_STATUS;
    }
    /**
     * Set SUB_STATUS value
     * @uses \EnumType\SUB_STATUS_VALUE::valueIsValid()
     * @uses \EnumType\SUB_STATUS_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sUB_STATUS
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setSUB_STATUS($sUB_STATUS = 'NEW')
    {
        // validation for constraint: enumeration
        if (!\EnumType\SUB_STATUS_VALUE::valueIsValid($sUB_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sUB_STATUS, implode(', ', \EnumType\SUB_STATUS_VALUE::getValidValues())), __LINE__);
        }
        $this->SUB_STATUS = $sUB_STATUS;
        return $this;
    }
    /**
     * Get ARCH_INVOICE_ID value
     * @return int|null
     */
    public function getARCH_INVOICE_ID()
    {
        return $this->ARCH_INVOICE_ID;
    }
    /**
     * Set ARCH_INVOICE_ID value
     * @param int $aRCH_INVOICE_ID
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setARCH_INVOICE_ID($aRCH_INVOICE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($aRCH_INVOICE_ID) && !is_numeric($aRCH_INVOICE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aRCH_INVOICE_ID)), __LINE__);
        }
        $this->ARCH_INVOICE_ID = $aRCH_INVOICE_ID;
        return $this;
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get EARCHIVE_TEST_FLAG value
     * @return string|null
     */
    public function getEARCHIVE_TEST_FLAG()
    {
        return $this->EARCHIVE_TEST_FLAG;
    }
    /**
     * Set EARCHIVE_TEST_FLAG value
     * @uses \EnumType\FLAG_VALUE::valueIsValid()
     * @uses \EnumType\FLAG_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eARCHIVE_TEST_FLAG
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setEARCHIVE_TEST_FLAG($eARCHIVE_TEST_FLAG = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FLAG_VALUE::valueIsValid($eARCHIVE_TEST_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eARCHIVE_TEST_FLAG, implode(', ', \EnumType\FLAG_VALUE::getValidValues())), __LINE__);
        }
        $this->EARCHIVE_TEST_FLAG = $eARCHIVE_TEST_FLAG;
        return $this;
    }
    /**
     * Get EARSIV_SMS_FLAG value
     * @return string|null
     */
    public function getEARSIV_SMS_FLAG()
    {
        return $this->EARSIV_SMS_FLAG;
    }
    /**
     * Set EARSIV_SMS_FLAG value
     * @param string $eARSIV_SMS_FLAG
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setEARSIV_SMS_FLAG($eARSIV_SMS_FLAG = null)
    {
        // validation for constraint: string
        if (!is_null($eARSIV_SMS_FLAG) && !is_string($eARSIV_SMS_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eARSIV_SMS_FLAG)), __LINE__);
        }
        $this->EARSIV_SMS_FLAG = $eARSIV_SMS_FLAG;
        return $this;
    }
    /**
     * Get SMS_PHONE_NUMBER value
     * @return string|null
     */
    public function getSMS_PHONE_NUMBER()
    {
        return $this->SMS_PHONE_NUMBER;
    }
    /**
     * Set SMS_PHONE_NUMBER value
     * @param string $sMS_PHONE_NUMBER
     * @return \StructType\EARSIV_PROPERTIES
     */
    public function setSMS_PHONE_NUMBER($sMS_PHONE_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($sMS_PHONE_NUMBER) && !is_string($sMS_PHONE_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sMS_PHONE_NUMBER)), __LINE__);
        }
        $this->SMS_PHONE_NUMBER = $sMS_PHONE_NUMBER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EARSIV_PROPERTIES
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
