<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CRLValuesType StructType
 * @subpackage Structs
 */
class CRLValuesType extends AbstractStructBase
{
    /**
     * The EncapsulatedCRLValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\EncapsulatedPKIDataType[]
     */
    public $EncapsulatedCRLValue;
    /**
     * Constructor method for CRLValuesType
     * @uses CRLValuesType::setEncapsulatedCRLValue()
     * @param \StructType\EncapsulatedPKIDataType[] $encapsulatedCRLValue
     */
    public function __construct(array $encapsulatedCRLValue = array())
    {
        $this
            ->setEncapsulatedCRLValue($encapsulatedCRLValue);
    }
    /**
     * Get EncapsulatedCRLValue value
     * @return \StructType\EncapsulatedPKIDataType[]|null
     */
    public function getEncapsulatedCRLValue()
    {
        return $this->EncapsulatedCRLValue;
    }
    /**
     * Set EncapsulatedCRLValue value
     * @throws \InvalidArgumentException
     * @param \StructType\EncapsulatedPKIDataType[] $encapsulatedCRLValue
     * @return \StructType\CRLValuesType
     */
    public function setEncapsulatedCRLValue(array $encapsulatedCRLValue = array())
    {
        foreach ($encapsulatedCRLValue as $cRLValuesTypeEncapsulatedCRLValueItem) {
            // validation for constraint: itemType
            if (!$cRLValuesTypeEncapsulatedCRLValueItem instanceof \StructType\EncapsulatedPKIDataType) {
                throw new \InvalidArgumentException(sprintf('The EncapsulatedCRLValue property can only contain items of \StructType\EncapsulatedPKIDataType, "%s" given', is_object($cRLValuesTypeEncapsulatedCRLValueItem) ? get_class($cRLValuesTypeEncapsulatedCRLValueItem) : gettype($cRLValuesTypeEncapsulatedCRLValueItem)), __LINE__);
            }
        }
        $this->EncapsulatedCRLValue = $encapsulatedCRLValue;
        return $this;
    }
    /**
     * Add item to EncapsulatedCRLValue value
     * @throws \InvalidArgumentException
     * @param \StructType\EncapsulatedPKIDataType $item
     * @return \StructType\CRLValuesType
     */
    public function addToEncapsulatedCRLValue(\StructType\EncapsulatedPKIDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EncapsulatedPKIDataType) {
            throw new \InvalidArgumentException(sprintf('The EncapsulatedCRLValue property can only contain items of \StructType\EncapsulatedPKIDataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EncapsulatedCRLValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CRLValuesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
