<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArchiveGetInvoiceInfoResponse StructType
 * Meta informations extracted from the WSDL
 * - type: ArchiveGetInvoiceInfoResponse
 * @subpackage Structs
 */
class ArchiveGetInvoiceInfoResponse extends AbstractStructBase
{
    /**
     * The PAGE_SIZE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $PAGE_SIZE;
    /**
     * The PAGE_NUMBER
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $PAGE_NUMBER;
    /**
     * The TOTAL_INVOICE_COUNT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TOTAL_INVOICE_COUNT;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The REQUEST_RETURN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\REQUEST_RETURNType
     */
    public $REQUEST_RETURN;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * Constructor method for ArchiveGetInvoiceInfoResponse
     * @uses ArchiveGetInvoiceInfoResponse::setPAGE_SIZE()
     * @uses ArchiveGetInvoiceInfoResponse::setPAGE_NUMBER()
     * @uses ArchiveGetInvoiceInfoResponse::setTOTAL_INVOICE_COUNT()
     * @uses ArchiveGetInvoiceInfoResponse::setINVOICE()
     * @uses ArchiveGetInvoiceInfoResponse::setREQUEST_RETURN()
     * @uses ArchiveGetInvoiceInfoResponse::setERROR_TYPE()
     * @param int $pAGE_SIZE
     * @param int $pAGE_NUMBER
     * @param int $tOTAL_INVOICE_COUNT
     * @param \StructType\INVOICE[] $iNVOICE
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     */
    public function __construct($pAGE_SIZE = null, $pAGE_NUMBER = null, $tOTAL_INVOICE_COUNT = null, array $iNVOICE = array(), \StructType\REQUEST_RETURNType $rEQUEST_RETURN = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this
            ->setPAGE_SIZE($pAGE_SIZE)
            ->setPAGE_NUMBER($pAGE_NUMBER)
            ->setTOTAL_INVOICE_COUNT($tOTAL_INVOICE_COUNT)
            ->setINVOICE($iNVOICE)
            ->setREQUEST_RETURN($rEQUEST_RETURN)
            ->setERROR_TYPE($eRROR_TYPE);
    }
    /**
     * Get PAGE_SIZE value
     * @return int|null
     */
    public function getPAGE_SIZE()
    {
        return $this->PAGE_SIZE;
    }
    /**
     * Set PAGE_SIZE value
     * @param int $pAGE_SIZE
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public function setPAGE_SIZE($pAGE_SIZE = null)
    {
        // validation for constraint: int
        if (!is_null($pAGE_SIZE) && !is_numeric($pAGE_SIZE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pAGE_SIZE)), __LINE__);
        }
        $this->PAGE_SIZE = $pAGE_SIZE;
        return $this;
    }
    /**
     * Get PAGE_NUMBER value
     * @return int|null
     */
    public function getPAGE_NUMBER()
    {
        return $this->PAGE_NUMBER;
    }
    /**
     * Set PAGE_NUMBER value
     * @param int $pAGE_NUMBER
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public function setPAGE_NUMBER($pAGE_NUMBER = null)
    {
        // validation for constraint: int
        if (!is_null($pAGE_NUMBER) && !is_numeric($pAGE_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pAGE_NUMBER)), __LINE__);
        }
        $this->PAGE_NUMBER = $pAGE_NUMBER;
        return $this;
    }
    /**
     * Get TOTAL_INVOICE_COUNT value
     * @return int|null
     */
    public function getTOTAL_INVOICE_COUNT()
    {
        return $this->TOTAL_INVOICE_COUNT;
    }
    /**
     * Set TOTAL_INVOICE_COUNT value
     * @param int $tOTAL_INVOICE_COUNT
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public function setTOTAL_INVOICE_COUNT($tOTAL_INVOICE_COUNT = null)
    {
        // validation for constraint: int
        if (!is_null($tOTAL_INVOICE_COUNT) && !is_numeric($tOTAL_INVOICE_COUNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tOTAL_INVOICE_COUNT)), __LINE__);
        }
        $this->TOTAL_INVOICE_COUNT = $tOTAL_INVOICE_COUNT;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $archiveGetInvoiceInfoResponseINVOICEItem) {
            // validation for constraint: itemType
            if (!$archiveGetInvoiceInfoResponseINVOICEItem instanceof \StructType\INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($archiveGetInvoiceInfoResponseINVOICEItem) ? get_class($archiveGetInvoiceInfoResponseINVOICEItem) : gettype($archiveGetInvoiceInfoResponseINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_RETURN value
     * @return \StructType\REQUEST_RETURNType|null
     */
    public function getREQUEST_RETURN()
    {
        return $this->REQUEST_RETURN;
    }
    /**
     * Set REQUEST_RETURN value
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public function setREQUEST_RETURN(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null)
    {
        $this->REQUEST_RETURN = $rEQUEST_RETURN;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArchiveGetInvoiceInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
