<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArchiveGenericDocumentRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ArchiveGenericDocumentRequest
 * @subpackage Structs
 */
class ArchiveGenericDocumentRequest extends AbstractStructBase
{
    /**
     * The GENERIC_CONTENT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\GENERIC_CONTENT[]
     */
    public $GENERIC_CONTENT;
    /**
     * The REQUEST_HEADER
     * @var \StructType\REQUEST_HEADERType
     */
    public $REQUEST_HEADER;
    /**
     * Constructor method for ArchiveGenericDocumentRequest
     * @uses ArchiveGenericDocumentRequest::setGENERIC_CONTENT()
     * @uses ArchiveGenericDocumentRequest::setREQUEST_HEADER()
     * @param \StructType\GENERIC_CONTENT[] $gENERIC_CONTENT
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     */
    public function __construct(array $gENERIC_CONTENT = array(), \StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this
            ->setGENERIC_CONTENT($gENERIC_CONTENT)
            ->setREQUEST_HEADER($rEQUEST_HEADER);
    }
    /**
     * Get GENERIC_CONTENT value
     * @return \StructType\GENERIC_CONTENT[]
     */
    public function getGENERIC_CONTENT()
    {
        return $this->GENERIC_CONTENT;
    }
    /**
     * Set GENERIC_CONTENT value
     * @throws \InvalidArgumentException
     * @param \StructType\GENERIC_CONTENT[] $gENERIC_CONTENT
     * @return \StructType\ArchiveGenericDocumentRequest
     */
    public function setGENERIC_CONTENT(array $gENERIC_CONTENT = array())
    {
        foreach ($gENERIC_CONTENT as $archiveGenericDocumentRequestGENERIC_CONTENTItem) {
            // validation for constraint: itemType
            if (!$archiveGenericDocumentRequestGENERIC_CONTENTItem instanceof \StructType\GENERIC_CONTENT) {
                throw new \InvalidArgumentException(sprintf('The GENERIC_CONTENT property can only contain items of \StructType\GENERIC_CONTENT, "%s" given', is_object($archiveGenericDocumentRequestGENERIC_CONTENTItem) ? get_class($archiveGenericDocumentRequestGENERIC_CONTENTItem) : gettype($archiveGenericDocumentRequestGENERIC_CONTENTItem)), __LINE__);
            }
        }
        $this->GENERIC_CONTENT = $gENERIC_CONTENT;
        return $this;
    }
    /**
     * Add item to GENERIC_CONTENT value
     * @throws \InvalidArgumentException
     * @param \StructType\GENERIC_CONTENT $item
     * @return \StructType\ArchiveGenericDocumentRequest
     */
    public function addToGENERIC_CONTENT(\StructType\GENERIC_CONTENT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GENERIC_CONTENT) {
            throw new \InvalidArgumentException(sprintf('The GENERIC_CONTENT property can only contain items of \StructType\GENERIC_CONTENT, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GENERIC_CONTENT[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_HEADER value
     * @return \StructType\REQUEST_HEADERType|null
     */
    public function getREQUEST_HEADER()
    {
        return $this->REQUEST_HEADER;
    }
    /**
     * Set REQUEST_HEADER value
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @return \StructType\ArchiveGenericDocumentRequest
     */
    public function setREQUEST_HEADER(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this->REQUEST_HEADER = $rEQUEST_HEADER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArchiveGenericDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
