<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Read ServiceType
 * @subpackage Services
 */
class Read extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReadFromArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArchiveInvoiceReadRequest $request
     * @return \StructType\ArchiveInvoiceReadResponse|bool
     */
    public function ReadFromArchive(\StructType\ArchiveInvoiceReadRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->ReadFromArchive($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEArchiveReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEArchiveReportRequest $request
     * @return \StructType\ReadEArchiveReportResponse|bool
     */
    public function ReadEArchiveReport(\StructType\ReadEArchiveReportRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->ReadEArchiveReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ArchiveInvoiceReadResponse|\StructType\ReadEArchiveReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
