<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for EA ServiceType
 * @subpackage Services
 */
class EA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EArchiveInvoiceCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EArchiveInvoiceCountRequest $request
     * @return \StructType\EArchiveInvoiceCountResponse|bool
     */
    public function EArchiveInvoiceCount(\StructType\EArchiveInvoiceCountRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->EArchiveInvoiceCount($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EArchiveInvoiceCountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
