<?php

namespace EnumType;

/**
 * This class stands for EARSIV_TYPE_VALUE EnumType
 * @subpackage Enumerations
 */
class EARSIV_TYPE_VALUE
{
    /**
     * Constant for value 'INTERNET'
     * @return string 'INTERNET'
     */
    const VALUE_INTERNET = 'INTERNET';
    /**
     * Constant for value 'NORMAL'
     * @return string 'NORMAL'
     */
    const VALUE_NORMAL = 'NORMAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTERNET
     * @uses self::VALUE_NORMAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTERNET,
            self::VALUE_NORMAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
