<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://connector.doganedonusum.com/EIArchiveWS/EFaturaArchive?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://connector.doganedonusum.com/EIArchiveWS/EFaturaArchive?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Write ServiceType
 */
$write = new \ServiceType\Write($options);
/**
 * Sample call for WriteToArchive operation/method
 */
if ($write->WriteToArchive(new \StructType\ArchiveInvoiceWriteRequest()) !== false) {
    print_r($write->getResult());
} else {
    print_r($write->getLastError());
}
/**
 * Sample call for WriteToArchiveExtended operation/method
 */
if ($write->WriteToArchiveExtended(new \StructType\ArchiveInvoiceExtendedRequest()) !== false) {
    print_r($write->getResult());
} else {
    print_r($write->getLastError());
}
/**
 * Samples for Read ServiceType
 */
$read = new \ServiceType\Read($options);
/**
 * Sample call for ReadFromArchive operation/method
 */
if ($read->ReadFromArchive(new \StructType\ArchiveInvoiceReadRequest()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEArchiveReport operation/method
 */
if ($read->ReadEArchiveReport(new \StructType\ReadEArchiveReportRequest()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Samples for Copy ServiceType
 */
$copy = new \ServiceType\Copy($options);
/**
 * Sample call for CopyToArchive operation/method
 */
if ($copy->CopyToArchive(new \StructType\ArchiveInvoiceCopyRequest()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Samples for Archive ServiceType
 */
$archive = new \ServiceType\Archive($options);
/**
 * Sample call for ArchiveGenericDocument operation/method
 */
if ($archive->ArchiveGenericDocument(new \StructType\ArchiveGenericDocumentRequest()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Sample call for ArchiveGetInvoiceInfo operation/method
 */
if ($archive->ArchiveGetInvoiceInfo(new \StructType\ArchiveGetInvoiceInfoRequest()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Generic ServiceType
 */
$generic = new \ServiceType\Generic($options);
/**
 * Sample call for GenericRead operation/method
 */
if ($generic->GenericRead(new \StructType\GenericReadRequest()) !== false) {
    print_r($generic->getResult());
} else {
    print_r($generic->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelEArchiveInvoice operation/method
 */
if ($cancel->CancelEArchiveInvoice(new \StructType\CancelEArchiveInvoiceRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelEDefter operation/method
 */
if ($cancel->CancelEDefter(new \StructType\CancelEDefterRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetEArchiveReport operation/method
 */
if ($get->GetEArchiveReport(new \StructType\GetEArchiveReportRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEArchiveInvoice operation/method
 */
if ($get->GetEArchiveInvoice(new \StructType\GetEArchiveInvoiceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEArchiveInvoiceStatus operation/method
 */
if ($get->GetEArchiveInvoiceStatus(new \StructType\GetEArchiveInvoiceStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGenericArchiveByPeriod operation/method
 */
if ($get->GetGenericArchiveByPeriod(new \StructType\GetGenericArchiveByPeriodRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGenericArchiveStatus operation/method
 */
if ($get->GetGenericArchiveStatus(new \StructType\GetGenericArchiveStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEmailEarchiveInvoice operation/method
 */
if ($get->GetEmailEarchiveInvoice(new \StructType\GetEmailEarchiveInvoiceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEArchiveInvoiceList operation/method
 */
if ($get->GetEArchiveInvoiceList(new \StructType\GetEArchiveInvoiceListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendSmsEarchiveInvoice operation/method
 */
if ($send->SendSmsEarchiveInvoice(new \StructType\SendSmsEarchiveInvoiceRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
/**
 * Sample call for MarkEArchiveInvoice operation/method
 */
if ($mark->MarkEArchiveInvoice(new \StructType\MarkEArchiveInvoiceRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for EA ServiceType
 */
$eA = new \ServiceType\EA($options);
/**
 * Sample call for EArchiveInvoiceCount operation/method
 */
if ($eA->EArchiveInvoiceCount(new \StructType\EArchiveInvoiceCountRequest()) !== false) {
    print_r($eA->getResult());
} else {
    print_r($eA->getLastError());
}
