<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vergiBilgisi StructType
 * @subpackage Structs
 */
class VergiBilgisi extends AbstractStructBase
{
    /**
     * The vergilerToplami
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 18
     * @var float
     */
    public $vergilerToplami;
    /**
     * The vergi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Vergi[]
     */
    public $vergi;
    /**
     * The tevkifat
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tevkifat[]
     */
    public $tevkifat;
    /**
     * Constructor method for vergiBilgisi
     * @uses VergiBilgisi::setVergilerToplami()
     * @uses VergiBilgisi::setVergi()
     * @uses VergiBilgisi::setTevkifat()
     * @param float $vergilerToplami
     * @param \StructType\Vergi[] $vergi
     * @param \StructType\Tevkifat[] $tevkifat
     */
    public function __construct($vergilerToplami = null, array $vergi = array(), array $tevkifat = array())
    {
        $this
            ->setVergilerToplami($vergilerToplami)
            ->setVergi($vergi)
            ->setTevkifat($tevkifat);
    }
    /**
     * Get vergilerToplami value
     * @return float|null
     */
    public function getVergilerToplami()
    {
        return $this->vergilerToplami;
    }
    /**
     * Set vergilerToplami value
     * @param float $vergilerToplami
     * @return \StructType\VergiBilgisi
     */
    public function setVergilerToplami($vergilerToplami = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($vergilerToplami) && strlen(substr($vergilerToplami, strpos($vergilerToplami, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($vergilerToplami, strpos($vergilerToplami, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($vergilerToplami) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $vergilerToplami)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($vergilerToplami, strpos($vergilerToplami, '.')))), __LINE__);
        }
        $this->vergilerToplami = $vergilerToplami;
        return $this;
    }
    /**
     * Get vergi value
     * @return \StructType\Vergi[]|null
     */
    public function getVergi()
    {
        return $this->vergi;
    }
    /**
     * Set vergi value
     * @throws \InvalidArgumentException
     * @param \StructType\Vergi[] $vergi
     * @return \StructType\VergiBilgisi
     */
    public function setVergi(array $vergi = array())
    {
        foreach ($vergi as $vergiBilgisiVergiItem) {
            // validation for constraint: itemType
            if (!$vergiBilgisiVergiItem instanceof \StructType\Vergi) {
                throw new \InvalidArgumentException(sprintf('The vergi property can only contain items of \StructType\Vergi, "%s" given', is_object($vergiBilgisiVergiItem) ? get_class($vergiBilgisiVergiItem) : gettype($vergiBilgisiVergiItem)), __LINE__);
            }
        }
        $this->vergi = $vergi;
        return $this;
    }
    /**
     * Add item to vergi value
     * @throws \InvalidArgumentException
     * @param \StructType\Vergi $item
     * @return \StructType\VergiBilgisi
     */
    public function addToVergi(\StructType\Vergi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Vergi) {
            throw new \InvalidArgumentException(sprintf('The vergi property can only contain items of \StructType\Vergi, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vergi[] = $item;
        return $this;
    }
    /**
     * Get tevkifat value
     * @return \StructType\Tevkifat[]|null
     */
    public function getTevkifat()
    {
        return $this->tevkifat;
    }
    /**
     * Set tevkifat value
     * @throws \InvalidArgumentException
     * @param \StructType\Tevkifat[] $tevkifat
     * @return \StructType\VergiBilgisi
     */
    public function setTevkifat(array $tevkifat = array())
    {
        foreach ($tevkifat as $vergiBilgisiTevkifatItem) {
            // validation for constraint: itemType
            if (!$vergiBilgisiTevkifatItem instanceof \StructType\Tevkifat) {
                throw new \InvalidArgumentException(sprintf('The tevkifat property can only contain items of \StructType\Tevkifat, "%s" given', is_object($vergiBilgisiTevkifatItem) ? get_class($vergiBilgisiTevkifatItem) : gettype($vergiBilgisiTevkifatItem)), __LINE__);
            }
        }
        $this->tevkifat = $tevkifat;
        return $this;
    }
    /**
     * Add item to tevkifat value
     * @throws \InvalidArgumentException
     * @param \StructType\Tevkifat $item
     * @return \StructType\VergiBilgisi
     */
    public function addToTevkifat(\StructType\Tevkifat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tevkifat) {
            throw new \InvalidArgumentException(sprintf('The tevkifat property can only contain items of \StructType\Tevkifat, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tevkifat[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VergiBilgisi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
