<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VALIDITY_PERIODType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Helper Entity; Contains validity period info for related entity
 * @subpackage Structs
 */
class VALIDITY_PERIODType extends AbstractStructBase
{
    /**
     * The SDATE
     * Meta informations extracted from the WSDL
     * - documentation: Validity start date of the entity
     * @var string
     */
    public $SDATE;
    /**
     * The EDATE
     * Meta informations extracted from the WSDL
     * - documentation: Validity end date of the entity
     * - minOccurs: 0
     * @var string
     */
    public $EDATE;
    /**
     * Constructor method for VALIDITY_PERIODType
     * @uses VALIDITY_PERIODType::setSDATE()
     * @uses VALIDITY_PERIODType::setEDATE()
     * @param string $sDATE
     * @param string $eDATE
     */
    public function __construct($sDATE = null, $eDATE = null)
    {
        $this
            ->setSDATE($sDATE)
            ->setEDATE($eDATE);
    }
    /**
     * Get SDATE value
     * @return string|null
     */
    public function getSDATE()
    {
        return $this->SDATE;
    }
    /**
     * Set SDATE value
     * @param string $sDATE
     * @return \StructType\VALIDITY_PERIODType
     */
    public function setSDATE($sDATE = null)
    {
        // validation for constraint: string
        if (!is_null($sDATE) && !is_string($sDATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sDATE)), __LINE__);
        }
        $this->SDATE = $sDATE;
        return $this;
    }
    /**
     * Get EDATE value
     * @return string|null
     */
    public function getEDATE()
    {
        return $this->EDATE;
    }
    /**
     * Set EDATE value
     * @param string $eDATE
     * @return \StructType\VALIDITY_PERIODType
     */
    public function setEDATE($eDATE = null)
    {
        // validation for constraint: string
        if (!is_null($eDATE) && !is_string($eDATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eDATE)), __LINE__);
        }
        $this->EDATE = $eDATE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VALIDITY_PERIODType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
