<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SPUserNoticeType StructType
 * @subpackage Structs
 */
class SPUserNoticeType extends AbstractStructBase
{
    /**
     * The NoticeRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoticeReferenceType
     */
    public $NoticeRef;
    /**
     * The ExplicitText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExplicitText;
    /**
     * Constructor method for SPUserNoticeType
     * @uses SPUserNoticeType::setNoticeRef()
     * @uses SPUserNoticeType::setExplicitText()
     * @param \StructType\NoticeReferenceType $noticeRef
     * @param string $explicitText
     */
    public function __construct(\StructType\NoticeReferenceType $noticeRef = null, $explicitText = null)
    {
        $this
            ->setNoticeRef($noticeRef)
            ->setExplicitText($explicitText);
    }
    /**
     * Get NoticeRef value
     * @return \StructType\NoticeReferenceType|null
     */
    public function getNoticeRef()
    {
        return $this->NoticeRef;
    }
    /**
     * Set NoticeRef value
     * @param \StructType\NoticeReferenceType $noticeRef
     * @return \StructType\SPUserNoticeType
     */
    public function setNoticeRef(\StructType\NoticeReferenceType $noticeRef = null)
    {
        $this->NoticeRef = $noticeRef;
        return $this;
    }
    /**
     * Get ExplicitText value
     * @return string|null
     */
    public function getExplicitText()
    {
        return $this->ExplicitText;
    }
    /**
     * Set ExplicitText value
     * @param string $explicitText
     * @return \StructType\SPUserNoticeType
     */
    public function setExplicitText($explicitText = null)
    {
        // validation for constraint: string
        if (!is_null($explicitText) && !is_string($explicitText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($explicitText)), __LINE__);
        }
        $this->ExplicitText = $explicitText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SPUserNoticeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
