<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for REPORT_INVOICE StructType
 * @subpackage Structs
 */
class REPORT_INVOICE extends AbstractStructBase
{
    /**
     * The INVOICE_ID
     * @var string
     */
    public $INVOICE_ID;
    /**
     * The UUID
     * @var string
     */
    public $UUID;
    /**
     * The STATUS
     * @var string
     */
    public $STATUS;
    /**
     * The STATUS_DESC
     * @var string
     */
    public $STATUS_DESC;
    /**
     * The INVOICE_DATE
     * @var string
     */
    public $INVOICE_DATE;
    /**
     * The CDATE
     * @var string
     */
    public $CDATE;
    /**
     * The PAYABLE_AMOUNT
     * @var int
     */
    public $PAYABLE_AMOUNT;
    /**
     * The EMAIL_STATUS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMAIL_STATUS;
    /**
     * The EMAIL_STATUS_DESC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMAIL_STATUS_DESC;
    /**
     * Constructor method for REPORT_INVOICE
     * @uses REPORT_INVOICE::setINVOICE_ID()
     * @uses REPORT_INVOICE::setUUID()
     * @uses REPORT_INVOICE::setSTATUS()
     * @uses REPORT_INVOICE::setSTATUS_DESC()
     * @uses REPORT_INVOICE::setINVOICE_DATE()
     * @uses REPORT_INVOICE::setCDATE()
     * @uses REPORT_INVOICE::setPAYABLE_AMOUNT()
     * @uses REPORT_INVOICE::setEMAIL_STATUS()
     * @uses REPORT_INVOICE::setEMAIL_STATUS_DESC()
     * @param string $iNVOICE_ID
     * @param string $uUID
     * @param string $sTATUS
     * @param string $sTATUS_DESC
     * @param string $iNVOICE_DATE
     * @param string $cDATE
     * @param int $pAYABLE_AMOUNT
     * @param string $eMAIL_STATUS
     * @param string $eMAIL_STATUS_DESC
     */
    public function __construct($iNVOICE_ID = null, $uUID = null, $sTATUS = null, $sTATUS_DESC = null, $iNVOICE_DATE = null, $cDATE = null, $pAYABLE_AMOUNT = null, $eMAIL_STATUS = null, $eMAIL_STATUS_DESC = null)
    {
        $this
            ->setINVOICE_ID($iNVOICE_ID)
            ->setUUID($uUID)
            ->setSTATUS($sTATUS)
            ->setSTATUS_DESC($sTATUS_DESC)
            ->setINVOICE_DATE($iNVOICE_DATE)
            ->setCDATE($cDATE)
            ->setPAYABLE_AMOUNT($pAYABLE_AMOUNT)
            ->setEMAIL_STATUS($eMAIL_STATUS)
            ->setEMAIL_STATUS_DESC($eMAIL_STATUS_DESC);
    }
    /**
     * Get INVOICE_ID value
     * @return string|null
     */
    public function getINVOICE_ID()
    {
        return $this->INVOICE_ID;
    }
    /**
     * Set INVOICE_ID value
     * @param string $iNVOICE_ID
     * @return \StructType\REPORT_INVOICE
     */
    public function setINVOICE_ID($iNVOICE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_ID) && !is_string($iNVOICE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICE_ID)), __LINE__);
        }
        $this->INVOICE_ID = $iNVOICE_ID;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\REPORT_INVOICE
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get STATUS value
     * @return string|null
     */
    public function getSTATUS()
    {
        return $this->STATUS;
    }
    /**
     * Set STATUS value
     * @param string $sTATUS
     * @return \StructType\REPORT_INVOICE
     */
    public function setSTATUS($sTATUS = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS) && !is_string($sTATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTATUS)), __LINE__);
        }
        $this->STATUS = $sTATUS;
        return $this;
    }
    /**
     * Get STATUS_DESC value
     * @return string|null
     */
    public function getSTATUS_DESC()
    {
        return $this->STATUS_DESC;
    }
    /**
     * Set STATUS_DESC value
     * @param string $sTATUS_DESC
     * @return \StructType\REPORT_INVOICE
     */
    public function setSTATUS_DESC($sTATUS_DESC = null)
    {
        // validation for constraint: string
        if (!is_null($sTATUS_DESC) && !is_string($sTATUS_DESC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTATUS_DESC)), __LINE__);
        }
        $this->STATUS_DESC = $sTATUS_DESC;
        return $this;
    }
    /**
     * Get INVOICE_DATE value
     * @return string|null
     */
    public function getINVOICE_DATE()
    {
        return $this->INVOICE_DATE;
    }
    /**
     * Set INVOICE_DATE value
     * @param string $iNVOICE_DATE
     * @return \StructType\REPORT_INVOICE
     */
    public function setINVOICE_DATE($iNVOICE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_DATE) && !is_string($iNVOICE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICE_DATE)), __LINE__);
        }
        $this->INVOICE_DATE = $iNVOICE_DATE;
        return $this;
    }
    /**
     * Get CDATE value
     * @return string|null
     */
    public function getCDATE()
    {
        return $this->CDATE;
    }
    /**
     * Set CDATE value
     * @param string $cDATE
     * @return \StructType\REPORT_INVOICE
     */
    public function setCDATE($cDATE = null)
    {
        // validation for constraint: string
        if (!is_null($cDATE) && !is_string($cDATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDATE)), __LINE__);
        }
        $this->CDATE = $cDATE;
        return $this;
    }
    /**
     * Get PAYABLE_AMOUNT value
     * @return int|null
     */
    public function getPAYABLE_AMOUNT()
    {
        return $this->PAYABLE_AMOUNT;
    }
    /**
     * Set PAYABLE_AMOUNT value
     * @param int $pAYABLE_AMOUNT
     * @return \StructType\REPORT_INVOICE
     */
    public function setPAYABLE_AMOUNT($pAYABLE_AMOUNT = null)
    {
        // validation for constraint: int
        if (!is_null($pAYABLE_AMOUNT) && !is_numeric($pAYABLE_AMOUNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pAYABLE_AMOUNT)), __LINE__);
        }
        $this->PAYABLE_AMOUNT = $pAYABLE_AMOUNT;
        return $this;
    }
    /**
     * Get EMAIL_STATUS value
     * @return string|null
     */
    public function getEMAIL_STATUS()
    {
        return $this->EMAIL_STATUS;
    }
    /**
     * Set EMAIL_STATUS value
     * @param string $eMAIL_STATUS
     * @return \StructType\REPORT_INVOICE
     */
    public function setEMAIL_STATUS($eMAIL_STATUS = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL_STATUS) && !is_string($eMAIL_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMAIL_STATUS)), __LINE__);
        }
        $this->EMAIL_STATUS = $eMAIL_STATUS;
        return $this;
    }
    /**
     * Get EMAIL_STATUS_DESC value
     * @return string|null
     */
    public function getEMAIL_STATUS_DESC()
    {
        return $this->EMAIL_STATUS_DESC;
    }
    /**
     * Set EMAIL_STATUS_DESC value
     * @param string $eMAIL_STATUS_DESC
     * @return \StructType\REPORT_INVOICE
     */
    public function setEMAIL_STATUS_DESC($eMAIL_STATUS_DESC = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL_STATUS_DESC) && !is_string($eMAIL_STATUS_DESC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMAIL_STATUS_DESC)), __LINE__);
        }
        $this->EMAIL_STATUS_DESC = $eMAIL_STATUS_DESC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\REPORT_INVOICE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
