<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PDF_PROPERTIES StructType
 * @subpackage Structs
 */
class PDF_PROPERTIES extends AbstractStructBase
{
    /**
     * The EARSIV_PDF_FLAG
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $EARSIV_PDF_FLAG;
    /**
     * The PDF_SIGNATURE_FLAG
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $PDF_SIGNATURE_FLAG;
    /**
     * The PDF_NAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PDF_NAME;
    /**
     * The EARCHIVE_PDF_XSLT_FILENAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EARCHIVE_PDF_XSLT_FILENAME;
    /**
     * The PDF_CONTENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Base64Binary
     */
    public $PDF_CONTENT;
    /**
     * The EARCHIVE_PDF_VISUALSIGN_FILE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EARCHIVE_PDF_VISUALSIGN_FILE;
    /**
     * Constructor method for PDF_PROPERTIES
     * @uses PDF_PROPERTIES::setEARSIV_PDF_FLAG()
     * @uses PDF_PROPERTIES::setPDF_SIGNATURE_FLAG()
     * @uses PDF_PROPERTIES::setPDF_NAME()
     * @uses PDF_PROPERTIES::setEARCHIVE_PDF_XSLT_FILENAME()
     * @uses PDF_PROPERTIES::setPDF_CONTENT()
     * @uses PDF_PROPERTIES::setEARCHIVE_PDF_VISUALSIGN_FILE()
     * @param string $eARSIV_PDF_FLAG
     * @param string $pDF_SIGNATURE_FLAG
     * @param string $pDF_NAME
     * @param string $eARCHIVE_PDF_XSLT_FILENAME
     * @param \StructType\Base64Binary $pDF_CONTENT
     * @param string $eARCHIVE_PDF_VISUALSIGN_FILE
     */
    public function __construct($eARSIV_PDF_FLAG = 'N', $pDF_SIGNATURE_FLAG = 'N', $pDF_NAME = null, $eARCHIVE_PDF_XSLT_FILENAME = null, \StructType\Base64Binary $pDF_CONTENT = null, $eARCHIVE_PDF_VISUALSIGN_FILE = null)
    {
        $this
            ->setEARSIV_PDF_FLAG($eARSIV_PDF_FLAG)
            ->setPDF_SIGNATURE_FLAG($pDF_SIGNATURE_FLAG)
            ->setPDF_NAME($pDF_NAME)
            ->setEARCHIVE_PDF_XSLT_FILENAME($eARCHIVE_PDF_XSLT_FILENAME)
            ->setPDF_CONTENT($pDF_CONTENT)
            ->setEARCHIVE_PDF_VISUALSIGN_FILE($eARCHIVE_PDF_VISUALSIGN_FILE);
    }
    /**
     * Get EARSIV_PDF_FLAG value
     * @return string|null
     */
    public function getEARSIV_PDF_FLAG()
    {
        return $this->EARSIV_PDF_FLAG;
    }
    /**
     * Set EARSIV_PDF_FLAG value
     * @uses \EnumType\FLAG_VALUE::valueIsValid()
     * @uses \EnumType\FLAG_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eARSIV_PDF_FLAG
     * @return \StructType\PDF_PROPERTIES
     */
    public function setEARSIV_PDF_FLAG($eARSIV_PDF_FLAG = 'N')
    {
        // validation for constraint: enumeration
        if (!\EnumType\FLAG_VALUE::valueIsValid($eARSIV_PDF_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eARSIV_PDF_FLAG, implode(', ', \EnumType\FLAG_VALUE::getValidValues())), __LINE__);
        }
        $this->EARSIV_PDF_FLAG = $eARSIV_PDF_FLAG;
        return $this;
    }
    /**
     * Get PDF_SIGNATURE_FLAG value
     * @return string|null
     */
    public function getPDF_SIGNATURE_FLAG()
    {
        return $this->PDF_SIGNATURE_FLAG;
    }
    /**
     * Set PDF_SIGNATURE_FLAG value
     * @uses \EnumType\FLAG_VALUE::valueIsValid()
     * @uses \EnumType\FLAG_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pDF_SIGNATURE_FLAG
     * @return \StructType\PDF_PROPERTIES
     */
    public function setPDF_SIGNATURE_FLAG($pDF_SIGNATURE_FLAG = 'N')
    {
        // validation for constraint: enumeration
        if (!\EnumType\FLAG_VALUE::valueIsValid($pDF_SIGNATURE_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pDF_SIGNATURE_FLAG, implode(', ', \EnumType\FLAG_VALUE::getValidValues())), __LINE__);
        }
        $this->PDF_SIGNATURE_FLAG = $pDF_SIGNATURE_FLAG;
        return $this;
    }
    /**
     * Get PDF_NAME value
     * @return string|null
     */
    public function getPDF_NAME()
    {
        return $this->PDF_NAME;
    }
    /**
     * Set PDF_NAME value
     * @param string $pDF_NAME
     * @return \StructType\PDF_PROPERTIES
     */
    public function setPDF_NAME($pDF_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($pDF_NAME) && !is_string($pDF_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDF_NAME)), __LINE__);
        }
        $this->PDF_NAME = $pDF_NAME;
        return $this;
    }
    /**
     * Get EARCHIVE_PDF_XSLT_FILENAME value
     * @return string|null
     */
    public function getEARCHIVE_PDF_XSLT_FILENAME()
    {
        return $this->EARCHIVE_PDF_XSLT_FILENAME;
    }
    /**
     * Set EARCHIVE_PDF_XSLT_FILENAME value
     * @param string $eARCHIVE_PDF_XSLT_FILENAME
     * @return \StructType\PDF_PROPERTIES
     */
    public function setEARCHIVE_PDF_XSLT_FILENAME($eARCHIVE_PDF_XSLT_FILENAME = null)
    {
        // validation for constraint: string
        if (!is_null($eARCHIVE_PDF_XSLT_FILENAME) && !is_string($eARCHIVE_PDF_XSLT_FILENAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eARCHIVE_PDF_XSLT_FILENAME)), __LINE__);
        }
        $this->EARCHIVE_PDF_XSLT_FILENAME = $eARCHIVE_PDF_XSLT_FILENAME;
        return $this;
    }
    /**
     * Get PDF_CONTENT value
     * @return \StructType\Base64Binary|null
     */
    public function getPDF_CONTENT()
    {
        return $this->PDF_CONTENT;
    }
    /**
     * Set PDF_CONTENT value
     * @param \StructType\Base64Binary $pDF_CONTENT
     * @return \StructType\PDF_PROPERTIES
     */
    public function setPDF_CONTENT(\StructType\Base64Binary $pDF_CONTENT = null)
    {
        $this->PDF_CONTENT = $pDF_CONTENT;
        return $this;
    }
    /**
     * Get EARCHIVE_PDF_VISUALSIGN_FILE value
     * @return string|null
     */
    public function getEARCHIVE_PDF_VISUALSIGN_FILE()
    {
        return $this->EARCHIVE_PDF_VISUALSIGN_FILE;
    }
    /**
     * Set EARCHIVE_PDF_VISUALSIGN_FILE value
     * @param string $eARCHIVE_PDF_VISUALSIGN_FILE
     * @return \StructType\PDF_PROPERTIES
     */
    public function setEARCHIVE_PDF_VISUALSIGN_FILE($eARCHIVE_PDF_VISUALSIGN_FILE = null)
    {
        // validation for constraint: string
        if (!is_null($eARCHIVE_PDF_VISUALSIGN_FILE) && !is_string($eARCHIVE_PDF_VISUALSIGN_FILE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eARCHIVE_PDF_VISUALSIGN_FILE)), __LINE__);
        }
        $this->EARCHIVE_PDF_VISUALSIGN_FILE = $eARCHIVE_PDF_VISUALSIGN_FILE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PDF_PROPERTIES
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
