<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OCSPIdentifierType StructType
 * @subpackage Structs
 */
class OCSPIdentifierType extends AbstractStructBase
{
    /**
     * The ResponderID
     * @var \StructType\ResponderIDType
     */
    public $ResponderID;
    /**
     * The ProducedAt
     * @var string
     */
    public $ProducedAt;
    /**
     * The URI
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * Constructor method for OCSPIdentifierType
     * @uses OCSPIdentifierType::setResponderID()
     * @uses OCSPIdentifierType::setProducedAt()
     * @uses OCSPIdentifierType::setURI()
     * @param \StructType\ResponderIDType $responderID
     * @param string $producedAt
     * @param string $uRI
     */
    public function __construct(\StructType\ResponderIDType $responderID = null, $producedAt = null, $uRI = null)
    {
        $this
            ->setResponderID($responderID)
            ->setProducedAt($producedAt)
            ->setURI($uRI);
    }
    /**
     * Get ResponderID value
     * @return \StructType\ResponderIDType|null
     */
    public function getResponderID()
    {
        return $this->ResponderID;
    }
    /**
     * Set ResponderID value
     * @param \StructType\ResponderIDType $responderID
     * @return \StructType\OCSPIdentifierType
     */
    public function setResponderID(\StructType\ResponderIDType $responderID = null)
    {
        $this->ResponderID = $responderID;
        return $this;
    }
    /**
     * Get ProducedAt value
     * @return string|null
     */
    public function getProducedAt()
    {
        return $this->ProducedAt;
    }
    /**
     * Set ProducedAt value
     * @param string $producedAt
     * @return \StructType\OCSPIdentifierType
     */
    public function setProducedAt($producedAt = null)
    {
        // validation for constraint: string
        if (!is_null($producedAt) && !is_string($producedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($producedAt)), __LINE__);
        }
        $this->ProducedAt = $producedAt;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\OCSPIdentifierType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OCSPIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
