<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEArchiveInvoiceResponse StructType
 * Meta informations extracted from the WSDL
 * - type: GetEArchiveInvoiceResponse
 * @subpackage Structs
 */
class GetEArchiveInvoiceResponse extends AbstractStructBase
{
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Base64Binary[]
     */
    public $INVOICE;
    /**
     * The REQUEST_RETURN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_RETURNType
     */
    public $REQUEST_RETURN;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * Constructor method for GetEArchiveInvoiceResponse
     * @uses GetEArchiveInvoiceResponse::setINVOICE()
     * @uses GetEArchiveInvoiceResponse::setREQUEST_RETURN()
     * @uses GetEArchiveInvoiceResponse::setERROR_TYPE()
     * @param \StructType\Base64Binary[] $iNVOICE
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     */
    public function __construct(array $iNVOICE = array(), \StructType\REQUEST_RETURNType $rEQUEST_RETURN = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this
            ->setINVOICE($iNVOICE)
            ->setREQUEST_RETURN($rEQUEST_RETURN)
            ->setERROR_TYPE($eRROR_TYPE);
    }
    /**
     * Get INVOICE value
     * @return \StructType\Base64Binary[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\Base64Binary[] $iNVOICE
     * @return \StructType\GetEArchiveInvoiceResponse
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $getEArchiveInvoiceResponseINVOICEItem) {
            // validation for constraint: itemType
            if (!$getEArchiveInvoiceResponseINVOICEItem instanceof \StructType\Base64Binary) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\Base64Binary, "%s" given', is_object($getEArchiveInvoiceResponseINVOICEItem) ? get_class($getEArchiveInvoiceResponseINVOICEItem) : gettype($getEArchiveInvoiceResponseINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\Base64Binary $item
     * @return \StructType\GetEArchiveInvoiceResponse
     */
    public function addToINVOICE(\StructType\Base64Binary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Base64Binary) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\Base64Binary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_RETURN value
     * @return \StructType\REQUEST_RETURNType|null
     */
    public function getREQUEST_RETURN()
    {
        return $this->REQUEST_RETURN;
    }
    /**
     * Set REQUEST_RETURN value
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @return \StructType\GetEArchiveInvoiceResponse
     */
    public function setREQUEST_RETURN(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null)
    {
        $this->REQUEST_RETURN = $rEQUEST_RETURN;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\GetEArchiveInvoiceResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEArchiveInvoiceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
