<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEArchiveInvoiceListResponse StructType
 * Meta informations extracted from the WSDL
 * - type: GetEArchiveInvoiceListResponse
 * @subpackage Structs
 */
class GetEArchiveInvoiceListResponse extends AbstractStructBase
{
    /**
     * The REQUEST_RETURN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\REQUEST_RETURNType
     */
    public $REQUEST_RETURN;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \StructType\EARCHIVEINV[]
     */
    public $INVOICE;
    /**
     * Constructor method for GetEArchiveInvoiceListResponse
     * @uses GetEArchiveInvoiceListResponse::setREQUEST_RETURN()
     * @uses GetEArchiveInvoiceListResponse::setERROR_TYPE()
     * @uses GetEArchiveInvoiceListResponse::setINVOICE()
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @param \StructType\EARCHIVEINV[] $iNVOICE
     */
    public function __construct(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null, array $iNVOICE = array())
    {
        $this
            ->setREQUEST_RETURN($rEQUEST_RETURN)
            ->setERROR_TYPE($eRROR_TYPE)
            ->setINVOICE($iNVOICE);
    }
    /**
     * Get REQUEST_RETURN value
     * @return \StructType\REQUEST_RETURNType|null
     */
    public function getREQUEST_RETURN()
    {
        return $this->REQUEST_RETURN;
    }
    /**
     * Set REQUEST_RETURN value
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @return \StructType\GetEArchiveInvoiceListResponse
     */
    public function setREQUEST_RETURN(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null)
    {
        $this->REQUEST_RETURN = $rEQUEST_RETURN;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\GetEArchiveInvoiceListResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\EARCHIVEINV[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\EARCHIVEINV[] $iNVOICE
     * @return \StructType\GetEArchiveInvoiceListResponse
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $getEArchiveInvoiceListResponseINVOICEItem) {
            // validation for constraint: itemType
            if (!$getEArchiveInvoiceListResponseINVOICEItem instanceof \StructType\EARCHIVEINV) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\EARCHIVEINV, "%s" given', is_object($getEArchiveInvoiceListResponseINVOICEItem) ? get_class($getEArchiveInvoiceListResponseINVOICEItem) : gettype($getEArchiveInvoiceListResponseINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\EARCHIVEINV $item
     * @return \StructType\GetEArchiveInvoiceListResponse
     */
    public function addToINVOICE(\StructType\EARCHIVEINV $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EARCHIVEINV) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\EARCHIVEINV, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEArchiveInvoiceListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
