<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for gercekKisi StructType
 * @subpackage Structs
 */
class GercekKisi extends AbstractStructBase
{
    /**
     * The tckn
     * Meta informations extracted from the WSDL
     * - pattern: \d\d\d\d\d\d\d\d\d\d\d
     * @var string
     */
    public $tckn;
    /**
     * The adiSoyadi
     * Meta informations extracted from the WSDL
     * - minLength: 2
     * @var string
     */
    public $adiSoyadi;
    /**
     * Constructor method for gercekKisi
     * @uses GercekKisi::setTckn()
     * @uses GercekKisi::setAdiSoyadi()
     * @param string $tckn
     * @param string $adiSoyadi
     */
    public function __construct($tckn = null, $adiSoyadi = null)
    {
        $this
            ->setTckn($tckn)
            ->setAdiSoyadi($adiSoyadi);
    }
    /**
     * Get tckn value
     * @return string|null
     */
    public function getTckn()
    {
        return $this->tckn;
    }
    /**
     * Set tckn value
     * @param string $tckn
     * @return \StructType\GercekKisi
     */
    public function setTckn($tckn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tckn) && !preg_match('/\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d/', $tckn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d\d\d\d\d\d\d\d\d\d\d", "%s" given', var_export($tckn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tckn) && !is_string($tckn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tckn)), __LINE__);
        }
        $this->tckn = $tckn;
        return $this;
    }
    /**
     * Get adiSoyadi value
     * @return string|null
     */
    public function getAdiSoyadi()
    {
        return $this->adiSoyadi;
    }
    /**
     * Set adiSoyadi value
     * @param string $adiSoyadi
     * @return \StructType\GercekKisi
     */
    public function setAdiSoyadi($adiSoyadi = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($adiSoyadi) && strlen($adiSoyadi) < 2) || (is_array($adiSoyadi) && count($adiSoyadi) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adiSoyadi) && !is_string($adiSoyadi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adiSoyadi)), __LINE__);
        }
        $this->adiSoyadi = $adiSoyadi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GercekKisi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
