<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for faturaType StructType
 * @subpackage Structs
 */
class FaturaType extends AbstractStructBase
{
    /**
     * The faturaNo
     * Meta informations extracted from the WSDL
     * - length: 16
     * - pattern: [A-Za-z0-9]{3}20[0-9]{2}[0-9]{9}
     * @var string
     */
    public $faturaNo;
    /**
     * The gonderimSekli
     * @var string
     */
    public $gonderimSekli;
    /**
     * The dosyaAdi
     * @var string
     */
    public $dosyaAdi;
    /**
     * The ozetDeger
     * @var string
     */
    public $ozetDeger;
    /**
     * The duzenlenmeTarihi
     * @var string
     */
    public $duzenlenmeTarihi;
    /**
     * The duzenlenmeZamani
     * Meta informations extracted from the WSDL
     * - minInclusive: 00:00:00
     * - pattern: (([01][0-9])|(2[0-3]))(:[0-5][0-9]){2}(\.[0-9]+)?
     * @var string
     */
    public $duzenlenmeZamani;
    /**
     * The toplamTutar
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 18
     * @var float
     */
    public $toplamTutar;
    /**
     * The odenecekTutar
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 18
     * @var float
     */
    public $odenecekTutar;
    /**
     * The paraBirimi
     * @var string
     */
    public $paraBirimi;
    /**
     * The vergiBilgisi
     * @var \StructType\VergiBilgisi
     */
    public $vergiBilgisi;
    /**
     * The aliciBilgileri
     * @var \StructType\AliciType
     */
    public $aliciBilgileri;
    /**
     * The internetSatisBilgi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InternetSatisBilgi
     */
    public $internetSatisBilgi;
    /**
     * The ynOkcFisBilgisi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\YnOkcFisBilgisi
     */
    public $ynOkcFisBilgisi;
    /**
     * Constructor method for faturaType
     * @uses FaturaType::setFaturaNo()
     * @uses FaturaType::setGonderimSekli()
     * @uses FaturaType::setDosyaAdi()
     * @uses FaturaType::setOzetDeger()
     * @uses FaturaType::setDuzenlenmeTarihi()
     * @uses FaturaType::setDuzenlenmeZamani()
     * @uses FaturaType::setToplamTutar()
     * @uses FaturaType::setOdenecekTutar()
     * @uses FaturaType::setParaBirimi()
     * @uses FaturaType::setVergiBilgisi()
     * @uses FaturaType::setAliciBilgileri()
     * @uses FaturaType::setInternetSatisBilgi()
     * @uses FaturaType::setYnOkcFisBilgisi()
     * @param string $faturaNo
     * @param string $gonderimSekli
     * @param string $dosyaAdi
     * @param string $ozetDeger
     * @param string $duzenlenmeTarihi
     * @param string $duzenlenmeZamani
     * @param float $toplamTutar
     * @param float $odenecekTutar
     * @param string $paraBirimi
     * @param \StructType\VergiBilgisi $vergiBilgisi
     * @param \StructType\AliciType $aliciBilgileri
     * @param \StructType\InternetSatisBilgi $internetSatisBilgi
     * @param \StructType\YnOkcFisBilgisi $ynOkcFisBilgisi
     */
    public function __construct($faturaNo = null, $gonderimSekli = null, $dosyaAdi = null, $ozetDeger = null, $duzenlenmeTarihi = null, $duzenlenmeZamani = null, $toplamTutar = null, $odenecekTutar = null, $paraBirimi = null, \StructType\VergiBilgisi $vergiBilgisi = null, \StructType\AliciType $aliciBilgileri = null, \StructType\InternetSatisBilgi $internetSatisBilgi = null, \StructType\YnOkcFisBilgisi $ynOkcFisBilgisi = null)
    {
        $this
            ->setFaturaNo($faturaNo)
            ->setGonderimSekli($gonderimSekli)
            ->setDosyaAdi($dosyaAdi)
            ->setOzetDeger($ozetDeger)
            ->setDuzenlenmeTarihi($duzenlenmeTarihi)
            ->setDuzenlenmeZamani($duzenlenmeZamani)
            ->setToplamTutar($toplamTutar)
            ->setOdenecekTutar($odenecekTutar)
            ->setParaBirimi($paraBirimi)
            ->setVergiBilgisi($vergiBilgisi)
            ->setAliciBilgileri($aliciBilgileri)
            ->setInternetSatisBilgi($internetSatisBilgi)
            ->setYnOkcFisBilgisi($ynOkcFisBilgisi);
    }
    /**
     * Get faturaNo value
     * @return string|null
     */
    public function getFaturaNo()
    {
        return $this->faturaNo;
    }
    /**
     * Set faturaNo value
     * @param string $faturaNo
     * @return \StructType\FaturaType
     */
    public function setFaturaNo($faturaNo = null)
    {
        // validation for constraint: length
        if ((is_scalar($faturaNo) && strlen($faturaNo) !== 16) || (is_array($faturaNo) && count($faturaNo) !== 16)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($faturaNo) && !preg_match('/[A-Za-z0-9]{3}20[0-9]{2}[0-9]{9}/', $faturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9]{3}20[0-9]{2}[0-9]{9}", "%s" given', var_export($faturaNo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($faturaNo) && !is_string($faturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faturaNo)), __LINE__);
        }
        $this->faturaNo = $faturaNo;
        return $this;
    }
    /**
     * Get gonderimSekli value
     * @return string|null
     */
    public function getGonderimSekli()
    {
        return $this->gonderimSekli;
    }
    /**
     * Set gonderimSekli value
     * @uses \EnumType\GonderimSekli::valueIsValid()
     * @uses \EnumType\GonderimSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gonderimSekli
     * @return \StructType\FaturaType
     */
    public function setGonderimSekli($gonderimSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GonderimSekli::valueIsValid($gonderimSekli)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gonderimSekli, implode(', ', \EnumType\GonderimSekli::getValidValues())), __LINE__);
        }
        $this->gonderimSekli = $gonderimSekli;
        return $this;
    }
    /**
     * Get dosyaAdi value
     * @return string|null
     */
    public function getDosyaAdi()
    {
        return $this->dosyaAdi;
    }
    /**
     * Set dosyaAdi value
     * @param string $dosyaAdi
     * @return \StructType\FaturaType
     */
    public function setDosyaAdi($dosyaAdi = null)
    {
        // validation for constraint: string
        if (!is_null($dosyaAdi) && !is_string($dosyaAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dosyaAdi)), __LINE__);
        }
        $this->dosyaAdi = $dosyaAdi;
        return $this;
    }
    /**
     * Get ozetDeger value
     * @return string|null
     */
    public function getOzetDeger()
    {
        return $this->ozetDeger;
    }
    /**
     * Set ozetDeger value
     * @param string $ozetDeger
     * @return \StructType\FaturaType
     */
    public function setOzetDeger($ozetDeger = null)
    {
        // validation for constraint: string
        if (!is_null($ozetDeger) && !is_string($ozetDeger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ozetDeger)), __LINE__);
        }
        $this->ozetDeger = $ozetDeger;
        return $this;
    }
    /**
     * Get duzenlenmeTarihi value
     * @return string|null
     */
    public function getDuzenlenmeTarihi()
    {
        return $this->duzenlenmeTarihi;
    }
    /**
     * Set duzenlenmeTarihi value
     * @param string $duzenlenmeTarihi
     * @return \StructType\FaturaType
     */
    public function setDuzenlenmeTarihi($duzenlenmeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($duzenlenmeTarihi) && !is_string($duzenlenmeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duzenlenmeTarihi)), __LINE__);
        }
        $this->duzenlenmeTarihi = $duzenlenmeTarihi;
        return $this;
    }
    /**
     * Get duzenlenmeZamani value
     * @return string|null
     */
    public function getDuzenlenmeZamani()
    {
        return $this->duzenlenmeZamani;
    }
    /**
     * Set duzenlenmeZamani value
     * @param string $duzenlenmeZamani
     * @return \StructType\FaturaType
     */
    public function setDuzenlenmeZamani($duzenlenmeZamani = null)
    {
        // validation for constraint: minInclusive
        if ($duzenlenmeZamani < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $duzenlenmeZamani), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($duzenlenmeZamani) && !preg_match('/(([01][0-9])|(2[0-3]))(:[0-5][0-9]){2}(\\.[0-9]+)?/', $duzenlenmeZamani)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([01][0-9])|(2[0-3]))(:[0-5][0-9]){2}(\.[0-9]+)?", "%s" given', var_export($duzenlenmeZamani, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($duzenlenmeZamani) && !is_string($duzenlenmeZamani)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duzenlenmeZamani)), __LINE__);
        }
        $this->duzenlenmeZamani = $duzenlenmeZamani;
        return $this;
    }
    /**
     * Get toplamTutar value
     * @return float|null
     */
    public function getToplamTutar()
    {
        return $this->toplamTutar;
    }
    /**
     * Set toplamTutar value
     * @param float $toplamTutar
     * @return \StructType\FaturaType
     */
    public function setToplamTutar($toplamTutar = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($toplamTutar) && strlen(substr($toplamTutar, strpos($toplamTutar, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($toplamTutar, strpos($toplamTutar, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($toplamTutar) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $toplamTutar)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($toplamTutar, strpos($toplamTutar, '.')))), __LINE__);
        }
        $this->toplamTutar = $toplamTutar;
        return $this;
    }
    /**
     * Get odenecekTutar value
     * @return float|null
     */
    public function getOdenecekTutar()
    {
        return $this->odenecekTutar;
    }
    /**
     * Set odenecekTutar value
     * @param float $odenecekTutar
     * @return \StructType\FaturaType
     */
    public function setOdenecekTutar($odenecekTutar = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($odenecekTutar) && strlen(substr($odenecekTutar, strpos($odenecekTutar, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($odenecekTutar, strpos($odenecekTutar, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($odenecekTutar) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $odenecekTutar)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($odenecekTutar, strpos($odenecekTutar, '.')))), __LINE__);
        }
        $this->odenecekTutar = $odenecekTutar;
        return $this;
    }
    /**
     * Get paraBirimi value
     * @return string|null
     */
    public function getParaBirimi()
    {
        return $this->paraBirimi;
    }
    /**
     * Set paraBirimi value
     * @uses \EnumType\ParaBirimi::valueIsValid()
     * @uses \EnumType\ParaBirimi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paraBirimi
     * @return \StructType\FaturaType
     */
    public function setParaBirimi($paraBirimi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ParaBirimi::valueIsValid($paraBirimi)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paraBirimi, implode(', ', \EnumType\ParaBirimi::getValidValues())), __LINE__);
        }
        $this->paraBirimi = $paraBirimi;
        return $this;
    }
    /**
     * Get vergiBilgisi value
     * @return \StructType\VergiBilgisi|null
     */
    public function getVergiBilgisi()
    {
        return $this->vergiBilgisi;
    }
    /**
     * Set vergiBilgisi value
     * @param \StructType\VergiBilgisi $vergiBilgisi
     * @return \StructType\FaturaType
     */
    public function setVergiBilgisi(\StructType\VergiBilgisi $vergiBilgisi = null)
    {
        $this->vergiBilgisi = $vergiBilgisi;
        return $this;
    }
    /**
     * Get aliciBilgileri value
     * @return \StructType\AliciType|null
     */
    public function getAliciBilgileri()
    {
        return $this->aliciBilgileri;
    }
    /**
     * Set aliciBilgileri value
     * @param \StructType\AliciType $aliciBilgileri
     * @return \StructType\FaturaType
     */
    public function setAliciBilgileri(\StructType\AliciType $aliciBilgileri = null)
    {
        $this->aliciBilgileri = $aliciBilgileri;
        return $this;
    }
    /**
     * Get internetSatisBilgi value
     * @return \StructType\InternetSatisBilgi|null
     */
    public function getInternetSatisBilgi()
    {
        return $this->internetSatisBilgi;
    }
    /**
     * Set internetSatisBilgi value
     * @param \StructType\InternetSatisBilgi $internetSatisBilgi
     * @return \StructType\FaturaType
     */
    public function setInternetSatisBilgi(\StructType\InternetSatisBilgi $internetSatisBilgi = null)
    {
        $this->internetSatisBilgi = $internetSatisBilgi;
        return $this;
    }
    /**
     * Get ynOkcFisBilgisi value
     * @return \StructType\YnOkcFisBilgisi|null
     */
    public function getYnOkcFisBilgisi()
    {
        return $this->ynOkcFisBilgisi;
    }
    /**
     * Set ynOkcFisBilgisi value
     * @param \StructType\YnOkcFisBilgisi $ynOkcFisBilgisi
     * @return \StructType\FaturaType
     */
    public function setYnOkcFisBilgisi(\StructType\YnOkcFisBilgisi $ynOkcFisBilgisi = null)
    {
        $this->ynOkcFisBilgisi = $ynOkcFisBilgisi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaturaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
