<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for faturaIptalType StructType
 * @subpackage Structs
 */
class FaturaIptalType extends AbstractStructBase
{
    /**
     * The faturaNo
     * Meta informations extracted from the WSDL
     * - length: 16
     * - pattern: [A-Za-z0-9]{3}20[0-9]{2}[0-9]{9}
     * @var string
     */
    public $faturaNo;
    /**
     * The iptalTarihi
     * @var string
     */
    public $iptalTarihi;
    /**
     * The toplamTutar
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 18
     * @var float
     */
    public $toplamTutar;
    /**
     * Constructor method for faturaIptalType
     * @uses FaturaIptalType::setFaturaNo()
     * @uses FaturaIptalType::setIptalTarihi()
     * @uses FaturaIptalType::setToplamTutar()
     * @param string $faturaNo
     * @param string $iptalTarihi
     * @param float $toplamTutar
     */
    public function __construct($faturaNo = null, $iptalTarihi = null, $toplamTutar = null)
    {
        $this
            ->setFaturaNo($faturaNo)
            ->setIptalTarihi($iptalTarihi)
            ->setToplamTutar($toplamTutar);
    }
    /**
     * Get faturaNo value
     * @return string|null
     */
    public function getFaturaNo()
    {
        return $this->faturaNo;
    }
    /**
     * Set faturaNo value
     * @param string $faturaNo
     * @return \StructType\FaturaIptalType
     */
    public function setFaturaNo($faturaNo = null)
    {
        // validation for constraint: length
        if ((is_scalar($faturaNo) && strlen($faturaNo) !== 16) || (is_array($faturaNo) && count($faturaNo) !== 16)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($faturaNo) && !preg_match('/[A-Za-z0-9]{3}20[0-9]{2}[0-9]{9}/', $faturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9]{3}20[0-9]{2}[0-9]{9}", "%s" given', var_export($faturaNo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($faturaNo) && !is_string($faturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faturaNo)), __LINE__);
        }
        $this->faturaNo = $faturaNo;
        return $this;
    }
    /**
     * Get iptalTarihi value
     * @return string|null
     */
    public function getIptalTarihi()
    {
        return $this->iptalTarihi;
    }
    /**
     * Set iptalTarihi value
     * @param string $iptalTarihi
     * @return \StructType\FaturaIptalType
     */
    public function setIptalTarihi($iptalTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($iptalTarihi) && !is_string($iptalTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iptalTarihi)), __LINE__);
        }
        $this->iptalTarihi = $iptalTarihi;
        return $this;
    }
    /**
     * Get toplamTutar value
     * @return float|null
     */
    public function getToplamTutar()
    {
        return $this->toplamTutar;
    }
    /**
     * Set toplamTutar value
     * @param float $toplamTutar
     * @return \StructType\FaturaIptalType
     */
    public function setToplamTutar($toplamTutar = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($toplamTutar) && strlen(substr($toplamTutar, strpos($toplamTutar, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($toplamTutar, strpos($toplamTutar, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($toplamTutar) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $toplamTutar)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($toplamTutar, strpos($toplamTutar, '.')))), __LINE__);
        }
        $this->toplamTutar = $toplamTutar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaturaIptalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
