<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DigestAlgAndValueType StructType
 * @subpackage Structs
 */
class DigestAlgAndValueType extends AbstractStructBase
{
    /**
     * The DigestMethod
     * Meta informations extracted from the WSDL
     * - ref: ds:DigestMethod
     * @var \StructType\DigestMethodType
     */
    public $DigestMethod;
    /**
     * The DigestValue
     * Meta informations extracted from the WSDL
     * - ref: ds:DigestValue
     * @var string
     */
    public $DigestValue;
    /**
     * Constructor method for DigestAlgAndValueType
     * @uses DigestAlgAndValueType::setDigestMethod()
     * @uses DigestAlgAndValueType::setDigestValue()
     * @param \StructType\DigestMethodType $digestMethod
     * @param string $digestValue
     */
    public function __construct(\StructType\DigestMethodType $digestMethod = null, $digestValue = null)
    {
        $this
            ->setDigestMethod($digestMethod)
            ->setDigestValue($digestValue);
    }
    /**
     * Get DigestMethod value
     * @return \StructType\DigestMethodType|null
     */
    public function getDigestMethod()
    {
        return $this->DigestMethod;
    }
    /**
     * Set DigestMethod value
     * @param \StructType\DigestMethodType $digestMethod
     * @return \StructType\DigestAlgAndValueType
     */
    public function setDigestMethod(\StructType\DigestMethodType $digestMethod = null)
    {
        $this->DigestMethod = $digestMethod;
        return $this;
    }
    /**
     * Get DigestValue value
     * @return string|null
     */
    public function getDigestValue()
    {
        return $this->DigestValue;
    }
    /**
     * Set DigestValue value
     * @param string $digestValue
     * @return \StructType\DigestAlgAndValueType
     */
    public function setDigestValue($digestValue = null)
    {
        // validation for constraint: string
        if (!is_null($digestValue) && !is_string($digestValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestValue)), __LINE__);
        }
        $this->DigestValue = $digestValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DigestAlgAndValueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
