<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataObjectFormatType StructType
 * @subpackage Structs
 */
class DataObjectFormatType extends AbstractStructBase
{
    /**
     * The ObjectReference
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ObjectReference;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ObjectIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ObjectIdentifierType
     */
    public $ObjectIdentifier;
    /**
     * The MimeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MimeType;
    /**
     * The Encoding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Encoding;
    /**
     * Constructor method for DataObjectFormatType
     * @uses DataObjectFormatType::setObjectReference()
     * @uses DataObjectFormatType::setDescription()
     * @uses DataObjectFormatType::setObjectIdentifier()
     * @uses DataObjectFormatType::setMimeType()
     * @uses DataObjectFormatType::setEncoding()
     * @param string $objectReference
     * @param string $description
     * @param \StructType\ObjectIdentifierType $objectIdentifier
     * @param string $mimeType
     * @param string $encoding
     */
    public function __construct($objectReference = null, $description = null, \StructType\ObjectIdentifierType $objectIdentifier = null, $mimeType = null, $encoding = null)
    {
        $this
            ->setObjectReference($objectReference)
            ->setDescription($description)
            ->setObjectIdentifier($objectIdentifier)
            ->setMimeType($mimeType)
            ->setEncoding($encoding);
    }
    /**
     * Get ObjectReference value
     * @return string
     */
    public function getObjectReference()
    {
        return $this->ObjectReference;
    }
    /**
     * Set ObjectReference value
     * @param string $objectReference
     * @return \StructType\DataObjectFormatType
     */
    public function setObjectReference($objectReference = null)
    {
        // validation for constraint: string
        if (!is_null($objectReference) && !is_string($objectReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectReference)), __LINE__);
        }
        $this->ObjectReference = $objectReference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DataObjectFormatType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ObjectIdentifier value
     * @return \StructType\ObjectIdentifierType|null
     */
    public function getObjectIdentifier()
    {
        return $this->ObjectIdentifier;
    }
    /**
     * Set ObjectIdentifier value
     * @param \StructType\ObjectIdentifierType $objectIdentifier
     * @return \StructType\DataObjectFormatType
     */
    public function setObjectIdentifier(\StructType\ObjectIdentifierType $objectIdentifier = null)
    {
        $this->ObjectIdentifier = $objectIdentifier;
        return $this;
    }
    /**
     * Get MimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->MimeType;
    }
    /**
     * Set MimeType value
     * @param string $mimeType
     * @return \StructType\DataObjectFormatType
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mimeType)), __LINE__);
        }
        $this->MimeType = $mimeType;
        return $this;
    }
    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @param string $encoding
     * @return \StructType\DataObjectFormatType
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encoding)), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataObjectFormatType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
