<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CertificateValuesType StructType
 * @subpackage Structs
 */
class CertificateValuesType extends AbstractStructBase
{
    /**
     * The EncapsulatedX509Certificate
     * @var \StructType\EncapsulatedPKIDataType
     */
    public $EncapsulatedX509Certificate;
    /**
     * The OtherCertificate
     * @var \StructType\AnyType
     */
    public $OtherCertificate;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for CertificateValuesType
     * @uses CertificateValuesType::setEncapsulatedX509Certificate()
     * @uses CertificateValuesType::setOtherCertificate()
     * @uses CertificateValuesType::setId()
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedX509Certificate
     * @param \StructType\AnyType $otherCertificate
     * @param string $id
     */
    public function __construct(\StructType\EncapsulatedPKIDataType $encapsulatedX509Certificate = null, \StructType\AnyType $otherCertificate = null, $id = null)
    {
        $this
            ->setEncapsulatedX509Certificate($encapsulatedX509Certificate)
            ->setOtherCertificate($otherCertificate)
            ->setId($id);
    }
    /**
     * Get EncapsulatedX509Certificate value
     * @return \StructType\EncapsulatedPKIDataType|null
     */
    public function getEncapsulatedX509Certificate()
    {
        return $this->EncapsulatedX509Certificate;
    }
    /**
     * Set EncapsulatedX509Certificate value
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedX509Certificate
     * @return \StructType\CertificateValuesType
     */
    public function setEncapsulatedX509Certificate(\StructType\EncapsulatedPKIDataType $encapsulatedX509Certificate = null)
    {
        $this->EncapsulatedX509Certificate = $encapsulatedX509Certificate;
        return $this;
    }
    /**
     * Get OtherCertificate value
     * @return \StructType\AnyType|null
     */
    public function getOtherCertificate()
    {
        return $this->OtherCertificate;
    }
    /**
     * Set OtherCertificate value
     * @param \StructType\AnyType $otherCertificate
     * @return \StructType\CertificateValuesType
     */
    public function setOtherCertificate(\StructType\AnyType $otherCertificate = null)
    {
        $this->OtherCertificate = $otherCertificate;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\CertificateValuesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertificateValuesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
