<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for COMMENTType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Holds Comment Info
 * @subpackage Structs
 */
class COMMENTType extends ENTITYBaseType
{
    /**
     * The COMMENT_ID
     * Meta informations extracted from the WSDL
     * - documentation: Comment Internal ID. -1 if NOT defined
     * @var int
     */
    public $COMMENT_ID;
    /**
     * The COMMENT
     * Meta informations extracted from the WSDL
     * - documentation: Comment
     * - maxLength: 1024
     * @var string
     */
    public $COMMENT;
    /**
     * The INTL_TXN_ID
     * Meta informations extracted from the WSDL
     * - documentation: INTL TXN ID if related to a Workflow
     * - minOccurs: 0
     * @var int
     */
    public $INTL_TXN_ID;
    /**
     * Constructor method for COMMENTType
     * @uses COMMENTType::setCOMMENT_ID()
     * @uses COMMENTType::setCOMMENT()
     * @uses COMMENTType::setINTL_TXN_ID()
     * @param int $cOMMENT_ID
     * @param string $cOMMENT
     * @param int $iNTL_TXN_ID
     */
    public function __construct($cOMMENT_ID = null, $cOMMENT = null, $iNTL_TXN_ID = null)
    {
        $this
            ->setCOMMENT_ID($cOMMENT_ID)
            ->setCOMMENT($cOMMENT)
            ->setINTL_TXN_ID($iNTL_TXN_ID);
    }
    /**
     * Get COMMENT_ID value
     * @return int|null
     */
    public function getCOMMENT_ID()
    {
        return $this->COMMENT_ID;
    }
    /**
     * Set COMMENT_ID value
     * @param int $cOMMENT_ID
     * @return \StructType\COMMENTType
     */
    public function setCOMMENT_ID($cOMMENT_ID = null)
    {
        // validation for constraint: int
        if (!is_null($cOMMENT_ID) && !is_numeric($cOMMENT_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cOMMENT_ID)), __LINE__);
        }
        $this->COMMENT_ID = $cOMMENT_ID;
        return $this;
    }
    /**
     * Get COMMENT value
     * @return string|null
     */
    public function getCOMMENT()
    {
        return $this->COMMENT;
    }
    /**
     * Set COMMENT value
     * @param string $cOMMENT
     * @return \StructType\COMMENTType
     */
    public function setCOMMENT($cOMMENT = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMMENT) && strlen($cOMMENT) > 1024) || (is_array($cOMMENT) && count($cOMMENT) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($cOMMENT) ? strlen($cOMMENT) : count($cOMMENT)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMMENT) && !is_string($cOMMENT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMMENT)), __LINE__);
        }
        $this->COMMENT = $cOMMENT;
        return $this;
    }
    /**
     * Get INTL_TXN_ID value
     * @return int|null
     */
    public function getINTL_TXN_ID()
    {
        return $this->INTL_TXN_ID;
    }
    /**
     * Set INTL_TXN_ID value
     * @param int $iNTL_TXN_ID
     * @return \StructType\COMMENTType
     */
    public function setINTL_TXN_ID($iNTL_TXN_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iNTL_TXN_ID) && !is_numeric($iNTL_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iNTL_TXN_ID)), __LINE__);
        }
        $this->INTL_TXN_ID = $iNTL_TXN_ID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\COMMENTType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
