<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArchiveInvoiceCopyRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ArchiveInvoiceCopyRequest
 * @subpackage Structs
 */
class ArchiveInvoiceCopyRequest extends AbstractStructBase
{
    /**
     * The INVOICE_UUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $INVOICE_UUID;
    /**
     * The PORTAL_DIRECTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $PORTAL_DIRECTION;
    /**
     * The REQUEST_HEADER
     * @var \StructType\REQUEST_HEADERType
     */
    public $REQUEST_HEADER;
    /**
     * The EXTERNAL_ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EXTERNAL_ID;
    /**
     * The ARCHIVE_NOTE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ARCHIVE_NOTE;
    /**
     * Constructor method for ArchiveInvoiceCopyRequest
     * @uses ArchiveInvoiceCopyRequest::setINVOICE_UUID()
     * @uses ArchiveInvoiceCopyRequest::setPORTAL_DIRECTION()
     * @uses ArchiveInvoiceCopyRequest::setREQUEST_HEADER()
     * @uses ArchiveInvoiceCopyRequest::setEXTERNAL_ID()
     * @uses ArchiveInvoiceCopyRequest::setARCHIVE_NOTE()
     * @param string[] $iNVOICE_UUID
     * @param string $pORTAL_DIRECTION
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @param int $eXTERNAL_ID
     * @param string $aRCHIVE_NOTE
     */
    public function __construct(array $iNVOICE_UUID = array(), $pORTAL_DIRECTION = null, \StructType\REQUEST_HEADERType $rEQUEST_HEADER = null, $eXTERNAL_ID = null, $aRCHIVE_NOTE = null)
    {
        $this
            ->setINVOICE_UUID($iNVOICE_UUID)
            ->setPORTAL_DIRECTION($pORTAL_DIRECTION)
            ->setREQUEST_HEADER($rEQUEST_HEADER)
            ->setEXTERNAL_ID($eXTERNAL_ID)
            ->setARCHIVE_NOTE($aRCHIVE_NOTE);
    }
    /**
     * Get INVOICE_UUID value
     * @return string[]
     */
    public function getINVOICE_UUID()
    {
        return $this->INVOICE_UUID;
    }
    /**
     * Set INVOICE_UUID value
     * @throws \InvalidArgumentException
     * @param string[] $iNVOICE_UUID
     * @return \StructType\ArchiveInvoiceCopyRequest
     */
    public function setINVOICE_UUID(array $iNVOICE_UUID = array())
    {
        foreach ($iNVOICE_UUID as $archiveInvoiceCopyRequestINVOICE_UUIDItem) {
            // validation for constraint: itemType
            if (!is_string($archiveInvoiceCopyRequestINVOICE_UUIDItem)) {
                throw new \InvalidArgumentException(sprintf('The INVOICE_UUID property can only contain items of string, "%s" given', is_object($archiveInvoiceCopyRequestINVOICE_UUIDItem) ? get_class($archiveInvoiceCopyRequestINVOICE_UUIDItem) : gettype($archiveInvoiceCopyRequestINVOICE_UUIDItem)), __LINE__);
            }
        }
        $this->INVOICE_UUID = $iNVOICE_UUID;
        return $this;
    }
    /**
     * Add item to INVOICE_UUID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ArchiveInvoiceCopyRequest
     */
    public function addToINVOICE_UUID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The INVOICE_UUID property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE_UUID[] = $item;
        return $this;
    }
    /**
     * Get PORTAL_DIRECTION value
     * @return string
     */
    public function getPORTAL_DIRECTION()
    {
        return $this->PORTAL_DIRECTION;
    }
    /**
     * Set PORTAL_DIRECTION value
     * @param string $pORTAL_DIRECTION
     * @return \StructType\ArchiveInvoiceCopyRequest
     */
    public function setPORTAL_DIRECTION($pORTAL_DIRECTION = null)
    {
        // validation for constraint: string
        if (!is_null($pORTAL_DIRECTION) && !is_string($pORTAL_DIRECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pORTAL_DIRECTION)), __LINE__);
        }
        $this->PORTAL_DIRECTION = $pORTAL_DIRECTION;
        return $this;
    }
    /**
     * Get REQUEST_HEADER value
     * @return \StructType\REQUEST_HEADERType|null
     */
    public function getREQUEST_HEADER()
    {
        return $this->REQUEST_HEADER;
    }
    /**
     * Set REQUEST_HEADER value
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @return \StructType\ArchiveInvoiceCopyRequest
     */
    public function setREQUEST_HEADER(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this->REQUEST_HEADER = $rEQUEST_HEADER;
        return $this;
    }
    /**
     * Get EXTERNAL_ID value
     * @return int|null
     */
    public function getEXTERNAL_ID()
    {
        return $this->EXTERNAL_ID;
    }
    /**
     * Set EXTERNAL_ID value
     * @param int $eXTERNAL_ID
     * @return \StructType\ArchiveInvoiceCopyRequest
     */
    public function setEXTERNAL_ID($eXTERNAL_ID = null)
    {
        // validation for constraint: int
        if (!is_null($eXTERNAL_ID) && !is_numeric($eXTERNAL_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eXTERNAL_ID)), __LINE__);
        }
        $this->EXTERNAL_ID = $eXTERNAL_ID;
        return $this;
    }
    /**
     * Get ARCHIVE_NOTE value
     * @return string|null
     */
    public function getARCHIVE_NOTE()
    {
        return $this->ARCHIVE_NOTE;
    }
    /**
     * Set ARCHIVE_NOTE value
     * @param string $aRCHIVE_NOTE
     * @return \StructType\ArchiveInvoiceCopyRequest
     */
    public function setARCHIVE_NOTE($aRCHIVE_NOTE = null)
    {
        // validation for constraint: string
        if (!is_null($aRCHIVE_NOTE) && !is_string($aRCHIVE_NOTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aRCHIVE_NOTE)), __LINE__);
        }
        $this->ARCHIVE_NOTE = $aRCHIVE_NOTE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArchiveInvoiceCopyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
