<?php

namespace EnumType;

/**
 * This class stands for VISIBILITY_TYPE EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Visibility Type
 * @subpackage Enumerations
 */
class VISIBILITY_TYPE
{
    /**
     * Constant for value 'PERSON'
     * @return string 'PERSON'
     */
    const VALUE_PERSON = 'PERSON';
    /**
     * Constant for value 'POSITION'
     * @return string 'POSITION'
     */
    const VALUE_POSITION = 'POSITION';
    /**
     * Constant for value 'POSITION_TYPE'
     * @return string 'POSITION_TYPE'
     */
    const VALUE_POSITION_TYPE = 'POSITION_TYPE';
    /**
     * Constant for value 'PEER'
     * @return string 'PEER'
     */
    const VALUE_PEER = 'PEER';
    /**
     * Constant for value 'TEAM'
     * @return string 'TEAM'
     */
    const VALUE_TEAM = 'TEAM';
    /**
     * Constant for value 'ORGANIZATION'
     * @return string 'ORGANIZATION'
     */
    const VALUE_ORGANIZATION = 'ORGANIZATION';
    /**
     * Constant for value 'ADMIN'
     * @return string 'ADMIN'
     */
    const VALUE_ADMIN = 'ADMIN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERSON
     * @uses self::VALUE_POSITION
     * @uses self::VALUE_POSITION_TYPE
     * @uses self::VALUE_PEER
     * @uses self::VALUE_TEAM
     * @uses self::VALUE_ORGANIZATION
     * @uses self::VALUE_ADMIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERSON,
            self::VALUE_POSITION,
            self::VALUE_POSITION_TYPE,
            self::VALUE_PEER,
            self::VALUE_TEAM,
            self::VALUE_ORGANIZATION,
            self::VALUE_ADMIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
