<?php

namespace EnumType;

/**
 * This class stands for SIGN_STATUS EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Sign
 * @subpackage Enumerations
 */
class SIGN_STATUS
{
    /**
     * Constant for value 'SIGNED'
     * @return string 'SIGNED'
     */
    const VALUE_SIGNED = 'SIGNED';
    /**
     * Constant for value 'SIGN_BY_CLIENTCER_TIFICATE'
     * @return string 'SIGN_BY_CLIENTCER_TIFICATE'
     */
    const VALUE_SIGN_BY_CLIENTCER_TIFICATE = 'SIGN_BY_CLIENTCER_TIFICATE';
    /**
     * Constant for value 'SIGN_BY_ENTEGRATOR_CERTIFICATE'
     * @return string 'SIGN_BY_ENTEGRATOR_CERTIFICATE'
     */
    const VALUE_SIGN_BY_ENTEGRATOR_CERTIFICATE = 'SIGN_BY_ENTEGRATOR_CERTIFICATE';
    /**
     * Constant for value 'NOSIGN'
     * @return string 'NOSIGN'
     */
    const VALUE_NOSIGN = 'NOSIGN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SIGNED
     * @uses self::VALUE_SIGN_BY_CLIENTCER_TIFICATE
     * @uses self::VALUE_SIGN_BY_ENTEGRATOR_CERTIFICATE
     * @uses self::VALUE_NOSIGN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SIGNED,
            self::VALUE_SIGN_BY_CLIENTCER_TIFICATE,
            self::VALUE_SIGN_BY_ENTEGRATOR_CERTIFICATE,
            self::VALUE_NOSIGN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
