<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectIdentifierType StructType
 * @subpackage Structs
 */
class ObjectIdentifierType extends AbstractStructBase
{
    /**
     * The Identifier
     * @var \StructType\IdentifierType
     */
    public $Identifier;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DocumentationReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocumentationReferencesType
     */
    public $DocumentationReferences;
    /**
     * Constructor method for ObjectIdentifierType
     * @uses ObjectIdentifierType::setIdentifier()
     * @uses ObjectIdentifierType::setDescription()
     * @uses ObjectIdentifierType::setDocumentationReferences()
     * @param \StructType\IdentifierType $identifier
     * @param string $description
     * @param \StructType\DocumentationReferencesType $documentationReferences
     */
    public function __construct(\StructType\IdentifierType $identifier = null, $description = null, \StructType\DocumentationReferencesType $documentationReferences = null)
    {
        $this
            ->setIdentifier($identifier)
            ->setDescription($description)
            ->setDocumentationReferences($documentationReferences);
    }
    /**
     * Get Identifier value
     * @return \StructType\IdentifierType|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param \StructType\IdentifierType $identifier
     * @return \StructType\ObjectIdentifierType
     */
    public function setIdentifier(\StructType\IdentifierType $identifier = null)
    {
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ObjectIdentifierType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DocumentationReferences value
     * @return \StructType\DocumentationReferencesType|null
     */
    public function getDocumentationReferences()
    {
        return $this->DocumentationReferences;
    }
    /**
     * Set DocumentationReferences value
     * @param \StructType\DocumentationReferencesType $documentationReferences
     * @return \StructType\ObjectIdentifierType
     */
    public function setDocumentationReferences(\StructType\DocumentationReferencesType $documentationReferences = null)
    {
        $this->DocumentationReferences = $documentationReferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ObjectIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
