<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OCSPValuesType StructType
 * @subpackage Structs
 */
class OCSPValuesType extends AbstractStructBase
{
    /**
     * The EncapsulatedOCSPValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\EncapsulatedPKIDataType[]
     */
    public $EncapsulatedOCSPValue;
    /**
     * Constructor method for OCSPValuesType
     * @uses OCSPValuesType::setEncapsulatedOCSPValue()
     * @param \StructType\EncapsulatedPKIDataType[] $encapsulatedOCSPValue
     */
    public function __construct(array $encapsulatedOCSPValue = array())
    {
        $this
            ->setEncapsulatedOCSPValue($encapsulatedOCSPValue);
    }
    /**
     * Get EncapsulatedOCSPValue value
     * @return \StructType\EncapsulatedPKIDataType[]|null
     */
    public function getEncapsulatedOCSPValue()
    {
        return $this->EncapsulatedOCSPValue;
    }
    /**
     * Set EncapsulatedOCSPValue value
     * @throws \InvalidArgumentException
     * @param \StructType\EncapsulatedPKIDataType[] $encapsulatedOCSPValue
     * @return \StructType\OCSPValuesType
     */
    public function setEncapsulatedOCSPValue(array $encapsulatedOCSPValue = array())
    {
        foreach ($encapsulatedOCSPValue as $oCSPValuesTypeEncapsulatedOCSPValueItem) {
            // validation for constraint: itemType
            if (!$oCSPValuesTypeEncapsulatedOCSPValueItem instanceof \StructType\EncapsulatedPKIDataType) {
                throw new \InvalidArgumentException(sprintf('The EncapsulatedOCSPValue property can only contain items of \StructType\EncapsulatedPKIDataType, "%s" given', is_object($oCSPValuesTypeEncapsulatedOCSPValueItem) ? get_class($oCSPValuesTypeEncapsulatedOCSPValueItem) : gettype($oCSPValuesTypeEncapsulatedOCSPValueItem)), __LINE__);
            }
        }
        $this->EncapsulatedOCSPValue = $encapsulatedOCSPValue;
        return $this;
    }
    /**
     * Add item to EncapsulatedOCSPValue value
     * @throws \InvalidArgumentException
     * @param \StructType\EncapsulatedPKIDataType $item
     * @return \StructType\OCSPValuesType
     */
    public function addToEncapsulatedOCSPValue(\StructType\EncapsulatedPKIDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EncapsulatedPKIDataType) {
            throw new \InvalidArgumentException(sprintf('The EncapsulatedOCSPValue property can only contain items of \StructType\EncapsulatedPKIDataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EncapsulatedOCSPValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OCSPValuesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
