<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OCSPRefsType StructType
 * @subpackage Structs
 */
class OCSPRefsType extends AbstractStructBase
{
    /**
     * The OCSPRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OCSPRefType[]
     */
    public $OCSPRef;
    /**
     * Constructor method for OCSPRefsType
     * @uses OCSPRefsType::setOCSPRef()
     * @param \StructType\OCSPRefType[] $oCSPRef
     */
    public function __construct(array $oCSPRef = array())
    {
        $this
            ->setOCSPRef($oCSPRef);
    }
    /**
     * Get OCSPRef value
     * @return \StructType\OCSPRefType[]|null
     */
    public function getOCSPRef()
    {
        return $this->OCSPRef;
    }
    /**
     * Set OCSPRef value
     * @throws \InvalidArgumentException
     * @param \StructType\OCSPRefType[] $oCSPRef
     * @return \StructType\OCSPRefsType
     */
    public function setOCSPRef(array $oCSPRef = array())
    {
        foreach ($oCSPRef as $oCSPRefsTypeOCSPRefItem) {
            // validation for constraint: itemType
            if (!$oCSPRefsTypeOCSPRefItem instanceof \StructType\OCSPRefType) {
                throw new \InvalidArgumentException(sprintf('The OCSPRef property can only contain items of \StructType\OCSPRefType, "%s" given', is_object($oCSPRefsTypeOCSPRefItem) ? get_class($oCSPRefsTypeOCSPRefItem) : gettype($oCSPRefsTypeOCSPRefItem)), __LINE__);
            }
        }
        $this->OCSPRef = $oCSPRef;
        return $this;
    }
    /**
     * Add item to OCSPRef value
     * @throws \InvalidArgumentException
     * @param \StructType\OCSPRefType $item
     * @return \StructType\OCSPRefsType
     */
    public function addToOCSPRef(\StructType\OCSPRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OCSPRefType) {
            throw new \InvalidArgumentException(sprintf('The OCSPRef property can only contain items of \StructType\OCSPRefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OCSPRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OCSPRefsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
