<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncludeType StructType
 * @subpackage Structs
 */
class IncludeType extends AbstractStructBase
{
    /**
     * The URI
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $URI;
    /**
     * The referencedData
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $referencedData;
    /**
     * Constructor method for IncludeType
     * @uses IncludeType::setURI()
     * @uses IncludeType::setReferencedData()
     * @param string $uRI
     * @param bool $referencedData
     */
    public function __construct($uRI = null, $referencedData = null)
    {
        $this
            ->setURI($uRI)
            ->setReferencedData($referencedData);
    }
    /**
     * Get URI value
     * @return string
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\IncludeType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get referencedData value
     * @return bool|null
     */
    public function getReferencedData()
    {
        return $this->referencedData;
    }
    /**
     * Set referencedData value
     * @param bool $referencedData
     * @return \StructType\IncludeType
     */
    public function setReferencedData($referencedData = null)
    {
        // validation for constraint: boolean
        if (!is_null($referencedData) && !is_bool($referencedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($referencedData)), __LINE__);
        }
        $this->referencedData = $referencedData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IncludeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
