<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEArchiveInvoiceStatusResponse StructType
 * Meta informations extracted from the WSDL
 * - type: GetEArchiveInvoiceStatusResponse
 * @subpackage Structs
 */
class GetEArchiveInvoiceStatusResponse extends AbstractStructBase
{
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 500
     * - minOccurs: 0
     * @var \StructType\EARCHIVE_INVOICE[]
     */
    public $INVOICE;
    /**
     * The REQUEST_RETURN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\REQUEST_RETURNType
     */
    public $REQUEST_RETURN;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * Constructor method for GetEArchiveInvoiceStatusResponse
     * @uses GetEArchiveInvoiceStatusResponse::setINVOICE()
     * @uses GetEArchiveInvoiceStatusResponse::setREQUEST_RETURN()
     * @uses GetEArchiveInvoiceStatusResponse::setERROR_TYPE()
     * @param \StructType\EARCHIVE_INVOICE[] $iNVOICE
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     */
    public function __construct(array $iNVOICE = array(), \StructType\REQUEST_RETURNType $rEQUEST_RETURN = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this
            ->setINVOICE($iNVOICE)
            ->setREQUEST_RETURN($rEQUEST_RETURN)
            ->setERROR_TYPE($eRROR_TYPE);
    }
    /**
     * Get INVOICE value
     * @return \StructType\EARCHIVE_INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\EARCHIVE_INVOICE[] $iNVOICE
     * @return \StructType\GetEArchiveInvoiceStatusResponse
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $getEArchiveInvoiceStatusResponseINVOICEItem) {
            // validation for constraint: itemType
            if (!$getEArchiveInvoiceStatusResponseINVOICEItem instanceof \StructType\EARCHIVE_INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\EARCHIVE_INVOICE, "%s" given', is_object($getEArchiveInvoiceStatusResponseINVOICEItem) ? get_class($getEArchiveInvoiceStatusResponseINVOICEItem) : gettype($getEArchiveInvoiceStatusResponseINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\EARCHIVE_INVOICE $item
     * @return \StructType\GetEArchiveInvoiceStatusResponse
     */
    public function addToINVOICE(\StructType\EARCHIVE_INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EARCHIVE_INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\EARCHIVE_INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_RETURN value
     * @return \StructType\REQUEST_RETURNType|null
     */
    public function getREQUEST_RETURN()
    {
        return $this->REQUEST_RETURN;
    }
    /**
     * Set REQUEST_RETURN value
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @return \StructType\GetEArchiveInvoiceStatusResponse
     */
    public function setREQUEST_RETURN(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null)
    {
        $this->REQUEST_RETURN = $rEQUEST_RETURN;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\GetEArchiveInvoiceStatusResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEArchiveInvoiceStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
