<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericReadRequest StructType
 * Meta informations extracted from the WSDL
 * - type: GenericReadRequest
 * @subpackage Structs
 */
class GenericReadRequest extends AbstractStructBase
{
    /**
     * The DOCUMENT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DOCUMENT[]
     */
    public $DOCUMENT;
    /**
     * The REQUEST_HEADER
     * @var \StructType\REQUEST_HEADERType
     */
    public $REQUEST_HEADER;
    /**
     * Constructor method for GenericReadRequest
     * @uses GenericReadRequest::setDOCUMENT()
     * @uses GenericReadRequest::setREQUEST_HEADER()
     * @param \StructType\DOCUMENT[] $dOCUMENT
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     */
    public function __construct(array $dOCUMENT = array(), \StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this
            ->setDOCUMENT($dOCUMENT)
            ->setREQUEST_HEADER($rEQUEST_HEADER);
    }
    /**
     * Get DOCUMENT value
     * @return \StructType\DOCUMENT[]
     */
    public function getDOCUMENT()
    {
        return $this->DOCUMENT;
    }
    /**
     * Set DOCUMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\DOCUMENT[] $dOCUMENT
     * @return \StructType\GenericReadRequest
     */
    public function setDOCUMENT(array $dOCUMENT = array())
    {
        foreach ($dOCUMENT as $genericReadRequestDOCUMENTItem) {
            // validation for constraint: itemType
            if (!$genericReadRequestDOCUMENTItem instanceof \StructType\DOCUMENT) {
                throw new \InvalidArgumentException(sprintf('The DOCUMENT property can only contain items of \StructType\DOCUMENT, "%s" given', is_object($genericReadRequestDOCUMENTItem) ? get_class($genericReadRequestDOCUMENTItem) : gettype($genericReadRequestDOCUMENTItem)), __LINE__);
            }
        }
        $this->DOCUMENT = $dOCUMENT;
        return $this;
    }
    /**
     * Add item to DOCUMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\DOCUMENT $item
     * @return \StructType\GenericReadRequest
     */
    public function addToDOCUMENT(\StructType\DOCUMENT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DOCUMENT) {
            throw new \InvalidArgumentException(sprintf('The DOCUMENT property can only contain items of \StructType\DOCUMENT, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DOCUMENT[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_HEADER value
     * @return \StructType\REQUEST_HEADERType|null
     */
    public function getREQUEST_HEADER()
    {
        return $this->REQUEST_HEADER;
    }
    /**
     * Set REQUEST_HEADER value
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @return \StructType\GenericReadRequest
     */
    public function setREQUEST_HEADER(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this->REQUEST_HEADER = $rEQUEST_HEADER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
