<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FIND_KEYType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Base type used for search keys
 * @subpackage Structs
 */
class FIND_KEYType extends AbstractStructBase
{
    /**
     * The DATETIME
     * Meta informations extracted from the WSDL
     * - documentation: DateTime of Inquire.
     * - minOccurs: 0
     * @var string
     */
    public $DATETIME;
    /**
     * The VISIBILITY_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VISIBILITY_TYPE;
    /**
     * Constructor method for FIND_KEYType
     * @uses FIND_KEYType::setDATETIME()
     * @uses FIND_KEYType::setVISIBILITY_TYPE()
     * @param string $dATETIME
     * @param string $vISIBILITY_TYPE
     */
    public function __construct($dATETIME = null, $vISIBILITY_TYPE = null)
    {
        $this
            ->setDATETIME($dATETIME)
            ->setVISIBILITY_TYPE($vISIBILITY_TYPE);
    }
    /**
     * Get DATETIME value
     * @return string|null
     */
    public function getDATETIME()
    {
        return $this->DATETIME;
    }
    /**
     * Set DATETIME value
     * @param string $dATETIME
     * @return \StructType\FIND_KEYType
     */
    public function setDATETIME($dATETIME = null)
    {
        // validation for constraint: string
        if (!is_null($dATETIME) && !is_string($dATETIME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dATETIME)), __LINE__);
        }
        $this->DATETIME = $dATETIME;
        return $this;
    }
    /**
     * Get VISIBILITY_TYPE value
     * @return string|null
     */
    public function getVISIBILITY_TYPE()
    {
        return $this->VISIBILITY_TYPE;
    }
    /**
     * Set VISIBILITY_TYPE value
     * @uses \EnumType\VISIBILITY_TYPE::valueIsValid()
     * @uses \EnumType\VISIBILITY_TYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vISIBILITY_TYPE
     * @return \StructType\FIND_KEYType
     */
    public function setVISIBILITY_TYPE($vISIBILITY_TYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VISIBILITY_TYPE::valueIsValid($vISIBILITY_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vISIBILITY_TYPE, implode(', ', \EnumType\VISIBILITY_TYPE::getValidValues())), __LINE__);
        }
        $this->VISIBILITY_TYPE = $vISIBILITY_TYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FIND_KEYType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
