<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FILESETType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Holds File Set Info
 * @subpackage Structs
 */
class FILESETType extends ENTITYBaseType
{
    /**
     * The FILE_SET_ID
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID indicating a set of files. If NOT defined may be set to -1
     * @var int
     */
    public $FILE_SET_ID;
    /**
     * The FILE
     * Meta informations extracted from the WSDL
     * - documentation: Files
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FILEType[]
     */
    public $FILE;
    /**
     * Constructor method for FILESETType
     * @uses FILESETType::setFILE_SET_ID()
     * @uses FILESETType::setFILE()
     * @param int $fILE_SET_ID
     * @param \StructType\FILEType[] $fILE
     */
    public function __construct($fILE_SET_ID = null, array $fILE = array())
    {
        $this
            ->setFILE_SET_ID($fILE_SET_ID)
            ->setFILE($fILE);
    }
    /**
     * Get FILE_SET_ID value
     * @return int|null
     */
    public function getFILE_SET_ID()
    {
        return $this->FILE_SET_ID;
    }
    /**
     * Set FILE_SET_ID value
     * @param int $fILE_SET_ID
     * @return \StructType\FILESETType
     */
    public function setFILE_SET_ID($fILE_SET_ID = null)
    {
        // validation for constraint: int
        if (!is_null($fILE_SET_ID) && !is_numeric($fILE_SET_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fILE_SET_ID)), __LINE__);
        }
        $this->FILE_SET_ID = $fILE_SET_ID;
        return $this;
    }
    /**
     * Get FILE value
     * @return \StructType\FILEType[]|null
     */
    public function getFILE()
    {
        return $this->FILE;
    }
    /**
     * Set FILE value
     * @throws \InvalidArgumentException
     * @param \StructType\FILEType[] $fILE
     * @return \StructType\FILESETType
     */
    public function setFILE(array $fILE = array())
    {
        foreach ($fILE as $fILESETTypeFILEItem) {
            // validation for constraint: itemType
            if (!$fILESETTypeFILEItem instanceof \StructType\FILEType) {
                throw new \InvalidArgumentException(sprintf('The FILE property can only contain items of \StructType\FILEType, "%s" given', is_object($fILESETTypeFILEItem) ? get_class($fILESETTypeFILEItem) : gettype($fILESETTypeFILEItem)), __LINE__);
            }
        }
        $this->FILE = $fILE;
        return $this;
    }
    /**
     * Add item to FILE value
     * @throws \InvalidArgumentException
     * @param \StructType\FILEType $item
     * @return \StructType\FILESETType
     */
    public function addToFILE(\StructType\FILEType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FILEType) {
            throw new \InvalidArgumentException(sprintf('The FILE property can only contain items of \StructType\FILEType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FILE[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FILESETType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
