<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ENTITYBaseType StructType
 * @subpackage Structs
 */
class ENTITYBaseType extends AbstractStructBase
{
    /**
     * The EL_ACTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Requested Elementary Action:C, R, U or D
     * - maxLength: 1
     * - pattern: [CRUDScruds]
     * @var string
     */
    public $EL_ACTION;
    /**
     * The VALIDITY_PERIOD
     * Meta informations extracted from the WSDL
     * - documentation: See VALIDITY_PERIOD type
     * - minOccurs: 0
     * @var \StructType\VALIDITY_PERIODType
     */
    public $VALIDITY_PERIOD;
    /**
     * The CHANGE_INFO
     * Meta informations extracted from the WSDL
     * - documentation: See CHANGE_INFO type
     * - minOccurs: 0
     * @var \StructType\CHANGE_INFOType
     */
    public $CHANGE_INFO;
    /**
     * The ACCESS_CONTROL_INFO
     * Meta informations extracted from the WSDL
     * - documentation: See ACCESS_CONTROL_INFO type
     * - minOccurs: 0
     * @var string
     */
    public $ACCESS_CONTROL_INFO;
    /**
     * Constructor method for ENTITYBaseType
     * @uses ENTITYBaseType::setEL_ACTION()
     * @uses ENTITYBaseType::setVALIDITY_PERIOD()
     * @uses ENTITYBaseType::setCHANGE_INFO()
     * @uses ENTITYBaseType::setACCESS_CONTROL_INFO()
     * @param string $eL_ACTION
     * @param \StructType\VALIDITY_PERIODType $vALIDITY_PERIOD
     * @param \StructType\CHANGE_INFOType $cHANGE_INFO
     * @param string $aCCESS_CONTROL_INFO
     */
    public function __construct($eL_ACTION = null, \StructType\VALIDITY_PERIODType $vALIDITY_PERIOD = null, \StructType\CHANGE_INFOType $cHANGE_INFO = null, $aCCESS_CONTROL_INFO = null)
    {
        $this
            ->setEL_ACTION($eL_ACTION)
            ->setVALIDITY_PERIOD($vALIDITY_PERIOD)
            ->setCHANGE_INFO($cHANGE_INFO)
            ->setACCESS_CONTROL_INFO($aCCESS_CONTROL_INFO);
    }
    /**
     * Get EL_ACTION value
     * @return string|null
     */
    public function getEL_ACTION()
    {
        return $this->EL_ACTION;
    }
    /**
     * Set EL_ACTION value
     * @param string $eL_ACTION
     * @return \StructType\ENTITYBaseType
     */
    public function setEL_ACTION($eL_ACTION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eL_ACTION) && strlen($eL_ACTION) > 1) || (is_array($eL_ACTION) && count($eL_ACTION) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($eL_ACTION) ? strlen($eL_ACTION) : count($eL_ACTION)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($eL_ACTION) && !preg_match('/[CRUDScruds]/', $eL_ACTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[CRUDScruds]", "%s" given', var_export($eL_ACTION, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eL_ACTION) && !is_string($eL_ACTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eL_ACTION)), __LINE__);
        }
        $this->EL_ACTION = $eL_ACTION;
        return $this;
    }
    /**
     * Get VALIDITY_PERIOD value
     * @return \StructType\VALIDITY_PERIODType|null
     */
    public function getVALIDITY_PERIOD()
    {
        return $this->VALIDITY_PERIOD;
    }
    /**
     * Set VALIDITY_PERIOD value
     * @param \StructType\VALIDITY_PERIODType $vALIDITY_PERIOD
     * @return \StructType\ENTITYBaseType
     */
    public function setVALIDITY_PERIOD(\StructType\VALIDITY_PERIODType $vALIDITY_PERIOD = null)
    {
        $this->VALIDITY_PERIOD = $vALIDITY_PERIOD;
        return $this;
    }
    /**
     * Get CHANGE_INFO value
     * @return \StructType\CHANGE_INFOType|null
     */
    public function getCHANGE_INFO()
    {
        return $this->CHANGE_INFO;
    }
    /**
     * Set CHANGE_INFO value
     * @param \StructType\CHANGE_INFOType $cHANGE_INFO
     * @return \StructType\ENTITYBaseType
     */
    public function setCHANGE_INFO(\StructType\CHANGE_INFOType $cHANGE_INFO = null)
    {
        $this->CHANGE_INFO = $cHANGE_INFO;
        return $this;
    }
    /**
     * Get ACCESS_CONTROL_INFO value
     * @return string|null
     */
    public function getACCESS_CONTROL_INFO()
    {
        return $this->ACCESS_CONTROL_INFO;
    }
    /**
     * Set ACCESS_CONTROL_INFO value
     * @param string $aCCESS_CONTROL_INFO
     * @return \StructType\ENTITYBaseType
     */
    public function setACCESS_CONTROL_INFO($aCCESS_CONTROL_INFO = null)
    {
        // validation for constraint: string
        if (!is_null($aCCESS_CONTROL_INFO) && !is_string($aCCESS_CONTROL_INFO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCCESS_CONTROL_INFO)), __LINE__);
        }
        $this->ACCESS_CONTROL_INFO = $aCCESS_CONTROL_INFO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ENTITYBaseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
