<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetEArchiveReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveReportRequest $request
     * @return \StructType\GetEArchiveReportResponse|bool
     */
    public function GetEArchiveReport(\StructType\GetEArchiveReportRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEArchiveReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoiceRequest $request
     * @return \StructType\GetEArchiveInvoiceResponse|bool
     */
    public function GetEArchiveInvoice(\StructType\GetEArchiveInvoiceRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEArchiveInvoice($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoiceStatusRequest $request
     * @return \StructType\GetEArchiveInvoiceStatusResponse|bool
     */
    public function GetEArchiveInvoiceStatus(\StructType\GetEArchiveInvoiceStatusRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEArchiveInvoiceStatus($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGenericArchiveByPeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGenericArchiveByPeriodRequest $request
     * @return \StructType\GetGenericArchiveByPeriodResponse|bool
     */
    public function GetGenericArchiveByPeriod(\StructType\GetGenericArchiveByPeriodRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGenericArchiveByPeriod($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGenericArchiveStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGenericArchiveStatusRequest $request
     * @return \StructType\GetGenericArchiveStatusResponse|bool
     */
    public function GetGenericArchiveStatus(\StructType\GetGenericArchiveStatusRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGenericArchiveStatus($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEmailEarchiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmailEarchiveInvoiceRequest $request
     * @return \StructType\GetEmailEarchiveInvoiceResponse|bool
     */
    public function GetEmailEarchiveInvoice(\StructType\GetEmailEarchiveInvoiceRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEmailEarchiveInvoice($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveInvoiceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoiceListRequest $request
     * @return \StructType\GetEArchiveInvoiceListResponse|bool
     */
    public function GetEArchiveInvoiceList(\StructType\GetEArchiveInvoiceListRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEArchiveInvoiceList($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetEArchiveInvoiceListResponse|\StructType\GetEArchiveInvoiceResponse|\StructType\GetEArchiveInvoiceStatusResponse|\StructType\GetEArchiveReportResponse|\StructType\GetEmailEarchiveInvoiceResponse|\StructType\GetGenericArchiveByPeriodResponse|\StructType\GetGenericArchiveStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
