<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vknTcknType StructType
 * @subpackage Structs
 */
class VknTcknType extends AbstractStructBase
{
    /**
     * The vkn
     * Meta informations extracted from the WSDL
     * - pattern: \d\d\d\d\d\d\d\d\d\d
     * @var string
     */
    public $vkn;
    /**
     * The tckn
     * Meta informations extracted from the WSDL
     * - pattern: \d\d\d\d\d\d\d\d\d\d\d
     * @var string
     */
    public $tckn;
    /**
     * Constructor method for vknTcknType
     * @uses VknTcknType::setVkn()
     * @uses VknTcknType::setTckn()
     * @param string $vkn
     * @param string $tckn
     */
    public function __construct($vkn = null, $tckn = null)
    {
        $this
            ->setVkn($vkn)
            ->setTckn($tckn);
    }
    /**
     * Get vkn value
     * @return string|null
     */
    public function getVkn()
    {
        return $this->vkn;
    }
    /**
     * Set vkn value
     * @param string $vkn
     * @return \StructType\VknTcknType
     */
    public function setVkn($vkn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vkn) && !preg_match('/\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d/', $vkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d\d\d\d\d\d\d\d\d\d", "%s" given', var_export($vkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vkn) && !is_string($vkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vkn)), __LINE__);
        }
        $this->vkn = $vkn;
        return $this;
    }
    /**
     * Get tckn value
     * @return string|null
     */
    public function getTckn()
    {
        return $this->tckn;
    }
    /**
     * Set tckn value
     * @param string $tckn
     * @return \StructType\VknTcknType
     */
    public function setTckn($tckn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tckn) && !preg_match('/\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d/', $tckn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d\d\d\d\d\d\d\d\d\d\d", "%s" given', var_export($tckn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tckn) && !is_string($tckn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tckn)), __LINE__);
        }
        $this->tckn = $tckn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VknTcknType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
