<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignedDataObjectPropertiesType StructType
 * @subpackage Structs
 */
class SignedDataObjectPropertiesType extends AbstractStructBase
{
    /**
     * The DataObjectFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DataObjectFormatType[]
     */
    public $DataObjectFormat;
    /**
     * The CommitmentTypeIndication
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommitmentTypeIndicationType[]
     */
    public $CommitmentTypeIndication;
    /**
     * The AllDataObjectsTimeStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XAdESTimeStampType[]
     */
    public $AllDataObjectsTimeStamp;
    /**
     * The IndividualDataObjectsTimeStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XAdESTimeStampType[]
     */
    public $IndividualDataObjectsTimeStamp;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignedDataObjectPropertiesType
     * @uses SignedDataObjectPropertiesType::setDataObjectFormat()
     * @uses SignedDataObjectPropertiesType::setCommitmentTypeIndication()
     * @uses SignedDataObjectPropertiesType::setAllDataObjectsTimeStamp()
     * @uses SignedDataObjectPropertiesType::setIndividualDataObjectsTimeStamp()
     * @uses SignedDataObjectPropertiesType::setId()
     * @param \StructType\DataObjectFormatType[] $dataObjectFormat
     * @param \StructType\CommitmentTypeIndicationType[] $commitmentTypeIndication
     * @param \StructType\XAdESTimeStampType[] $allDataObjectsTimeStamp
     * @param \StructType\XAdESTimeStampType[] $individualDataObjectsTimeStamp
     * @param string $id
     */
    public function __construct(array $dataObjectFormat = array(), array $commitmentTypeIndication = array(), array $allDataObjectsTimeStamp = array(), array $individualDataObjectsTimeStamp = array(), $id = null)
    {
        $this
            ->setDataObjectFormat($dataObjectFormat)
            ->setCommitmentTypeIndication($commitmentTypeIndication)
            ->setAllDataObjectsTimeStamp($allDataObjectsTimeStamp)
            ->setIndividualDataObjectsTimeStamp($individualDataObjectsTimeStamp)
            ->setId($id);
    }
    /**
     * Get DataObjectFormat value
     * @return \StructType\DataObjectFormatType[]|null
     */
    public function getDataObjectFormat()
    {
        return $this->DataObjectFormat;
    }
    /**
     * Set DataObjectFormat value
     * @throws \InvalidArgumentException
     * @param \StructType\DataObjectFormatType[] $dataObjectFormat
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function setDataObjectFormat(array $dataObjectFormat = array())
    {
        foreach ($dataObjectFormat as $signedDataObjectPropertiesTypeDataObjectFormatItem) {
            // validation for constraint: itemType
            if (!$signedDataObjectPropertiesTypeDataObjectFormatItem instanceof \StructType\DataObjectFormatType) {
                throw new \InvalidArgumentException(sprintf('The DataObjectFormat property can only contain items of \StructType\DataObjectFormatType, "%s" given', is_object($signedDataObjectPropertiesTypeDataObjectFormatItem) ? get_class($signedDataObjectPropertiesTypeDataObjectFormatItem) : gettype($signedDataObjectPropertiesTypeDataObjectFormatItem)), __LINE__);
            }
        }
        $this->DataObjectFormat = $dataObjectFormat;
        return $this;
    }
    /**
     * Add item to DataObjectFormat value
     * @throws \InvalidArgumentException
     * @param \StructType\DataObjectFormatType $item
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function addToDataObjectFormat(\StructType\DataObjectFormatType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DataObjectFormatType) {
            throw new \InvalidArgumentException(sprintf('The DataObjectFormat property can only contain items of \StructType\DataObjectFormatType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DataObjectFormat[] = $item;
        return $this;
    }
    /**
     * Get CommitmentTypeIndication value
     * @return \StructType\CommitmentTypeIndicationType[]|null
     */
    public function getCommitmentTypeIndication()
    {
        return $this->CommitmentTypeIndication;
    }
    /**
     * Set CommitmentTypeIndication value
     * @throws \InvalidArgumentException
     * @param \StructType\CommitmentTypeIndicationType[] $commitmentTypeIndication
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function setCommitmentTypeIndication(array $commitmentTypeIndication = array())
    {
        foreach ($commitmentTypeIndication as $signedDataObjectPropertiesTypeCommitmentTypeIndicationItem) {
            // validation for constraint: itemType
            if (!$signedDataObjectPropertiesTypeCommitmentTypeIndicationItem instanceof \StructType\CommitmentTypeIndicationType) {
                throw new \InvalidArgumentException(sprintf('The CommitmentTypeIndication property can only contain items of \StructType\CommitmentTypeIndicationType, "%s" given', is_object($signedDataObjectPropertiesTypeCommitmentTypeIndicationItem) ? get_class($signedDataObjectPropertiesTypeCommitmentTypeIndicationItem) : gettype($signedDataObjectPropertiesTypeCommitmentTypeIndicationItem)), __LINE__);
            }
        }
        $this->CommitmentTypeIndication = $commitmentTypeIndication;
        return $this;
    }
    /**
     * Add item to CommitmentTypeIndication value
     * @throws \InvalidArgumentException
     * @param \StructType\CommitmentTypeIndicationType $item
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function addToCommitmentTypeIndication(\StructType\CommitmentTypeIndicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommitmentTypeIndicationType) {
            throw new \InvalidArgumentException(sprintf('The CommitmentTypeIndication property can only contain items of \StructType\CommitmentTypeIndicationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommitmentTypeIndication[] = $item;
        return $this;
    }
    /**
     * Get AllDataObjectsTimeStamp value
     * @return \StructType\XAdESTimeStampType[]|null
     */
    public function getAllDataObjectsTimeStamp()
    {
        return $this->AllDataObjectsTimeStamp;
    }
    /**
     * Set AllDataObjectsTimeStamp value
     * @throws \InvalidArgumentException
     * @param \StructType\XAdESTimeStampType[] $allDataObjectsTimeStamp
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function setAllDataObjectsTimeStamp(array $allDataObjectsTimeStamp = array())
    {
        foreach ($allDataObjectsTimeStamp as $signedDataObjectPropertiesTypeAllDataObjectsTimeStampItem) {
            // validation for constraint: itemType
            if (!$signedDataObjectPropertiesTypeAllDataObjectsTimeStampItem instanceof \StructType\XAdESTimeStampType) {
                throw new \InvalidArgumentException(sprintf('The AllDataObjectsTimeStamp property can only contain items of \StructType\XAdESTimeStampType, "%s" given', is_object($signedDataObjectPropertiesTypeAllDataObjectsTimeStampItem) ? get_class($signedDataObjectPropertiesTypeAllDataObjectsTimeStampItem) : gettype($signedDataObjectPropertiesTypeAllDataObjectsTimeStampItem)), __LINE__);
            }
        }
        $this->AllDataObjectsTimeStamp = $allDataObjectsTimeStamp;
        return $this;
    }
    /**
     * Add item to AllDataObjectsTimeStamp value
     * @throws \InvalidArgumentException
     * @param \StructType\XAdESTimeStampType $item
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function addToAllDataObjectsTimeStamp(\StructType\XAdESTimeStampType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XAdESTimeStampType) {
            throw new \InvalidArgumentException(sprintf('The AllDataObjectsTimeStamp property can only contain items of \StructType\XAdESTimeStampType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AllDataObjectsTimeStamp[] = $item;
        return $this;
    }
    /**
     * Get IndividualDataObjectsTimeStamp value
     * @return \StructType\XAdESTimeStampType[]|null
     */
    public function getIndividualDataObjectsTimeStamp()
    {
        return $this->IndividualDataObjectsTimeStamp;
    }
    /**
     * Set IndividualDataObjectsTimeStamp value
     * @throws \InvalidArgumentException
     * @param \StructType\XAdESTimeStampType[] $individualDataObjectsTimeStamp
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function setIndividualDataObjectsTimeStamp(array $individualDataObjectsTimeStamp = array())
    {
        foreach ($individualDataObjectsTimeStamp as $signedDataObjectPropertiesTypeIndividualDataObjectsTimeStampItem) {
            // validation for constraint: itemType
            if (!$signedDataObjectPropertiesTypeIndividualDataObjectsTimeStampItem instanceof \StructType\XAdESTimeStampType) {
                throw new \InvalidArgumentException(sprintf('The IndividualDataObjectsTimeStamp property can only contain items of \StructType\XAdESTimeStampType, "%s" given', is_object($signedDataObjectPropertiesTypeIndividualDataObjectsTimeStampItem) ? get_class($signedDataObjectPropertiesTypeIndividualDataObjectsTimeStampItem) : gettype($signedDataObjectPropertiesTypeIndividualDataObjectsTimeStampItem)), __LINE__);
            }
        }
        $this->IndividualDataObjectsTimeStamp = $individualDataObjectsTimeStamp;
        return $this;
    }
    /**
     * Add item to IndividualDataObjectsTimeStamp value
     * @throws \InvalidArgumentException
     * @param \StructType\XAdESTimeStampType $item
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function addToIndividualDataObjectsTimeStamp(\StructType\XAdESTimeStampType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XAdESTimeStampType) {
            throw new \InvalidArgumentException(sprintf('The IndividualDataObjectsTimeStamp property can only contain items of \StructType\XAdESTimeStampType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IndividualDataObjectsTimeStamp[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignedDataObjectPropertiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
