<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OCSPRefType StructType
 * @subpackage Structs
 */
class OCSPRefType extends AbstractStructBase
{
    /**
     * The OCSPIdentifier
     * @var \StructType\OCSPIdentifierType
     */
    public $OCSPIdentifier;
    /**
     * The DigestAlgAndValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DigestAlgAndValueType
     */
    public $DigestAlgAndValue;
    /**
     * Constructor method for OCSPRefType
     * @uses OCSPRefType::setOCSPIdentifier()
     * @uses OCSPRefType::setDigestAlgAndValue()
     * @param \StructType\OCSPIdentifierType $oCSPIdentifier
     * @param \StructType\DigestAlgAndValueType $digestAlgAndValue
     */
    public function __construct(\StructType\OCSPIdentifierType $oCSPIdentifier = null, \StructType\DigestAlgAndValueType $digestAlgAndValue = null)
    {
        $this
            ->setOCSPIdentifier($oCSPIdentifier)
            ->setDigestAlgAndValue($digestAlgAndValue);
    }
    /**
     * Get OCSPIdentifier value
     * @return \StructType\OCSPIdentifierType|null
     */
    public function getOCSPIdentifier()
    {
        return $this->OCSPIdentifier;
    }
    /**
     * Set OCSPIdentifier value
     * @param \StructType\OCSPIdentifierType $oCSPIdentifier
     * @return \StructType\OCSPRefType
     */
    public function setOCSPIdentifier(\StructType\OCSPIdentifierType $oCSPIdentifier = null)
    {
        $this->OCSPIdentifier = $oCSPIdentifier;
        return $this;
    }
    /**
     * Get DigestAlgAndValue value
     * @return \StructType\DigestAlgAndValueType|null
     */
    public function getDigestAlgAndValue()
    {
        return $this->DigestAlgAndValue;
    }
    /**
     * Set DigestAlgAndValue value
     * @param \StructType\DigestAlgAndValueType $digestAlgAndValue
     * @return \StructType\OCSPRefType
     */
    public function setDigestAlgAndValue(\StructType\DigestAlgAndValueType $digestAlgAndValue = null)
    {
        $this->DigestAlgAndValue = $digestAlgAndValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OCSPRefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
