<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEArchiveReportResponse StructType
 * Meta informations extracted from the WSDL
 * - type: GetEArchiveReportResponse
 * @subpackage Structs
 */
class GetEArchiveReportResponse extends AbstractStructBase
{
    /**
     * The REPORT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\REPORT[]
     */
    public $REPORT;
    /**
     * The INVOICE
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\REPORT_INVOICE[]
     */
    public $INVOICE;
    /**
     * The REQUEST_RETURN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_RETURNType
     */
    public $REQUEST_RETURN;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * Constructor method for GetEArchiveReportResponse
     * @uses GetEArchiveReportResponse::setREPORT()
     * @uses GetEArchiveReportResponse::setINVOICE()
     * @uses GetEArchiveReportResponse::setREQUEST_RETURN()
     * @uses GetEArchiveReportResponse::setERROR_TYPE()
     * @param \StructType\REPORT[] $rEPORT
     * @param \StructType\REPORT_INVOICE[] $iNVOICE
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     */
    public function __construct(array $rEPORT = array(), array $iNVOICE = array(), \StructType\REQUEST_RETURNType $rEQUEST_RETURN = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this
            ->setREPORT($rEPORT)
            ->setINVOICE($iNVOICE)
            ->setREQUEST_RETURN($rEQUEST_RETURN)
            ->setERROR_TYPE($eRROR_TYPE);
    }
    /**
     * Get REPORT value
     * @return \StructType\REPORT[]|null
     */
    public function getREPORT()
    {
        return $this->REPORT;
    }
    /**
     * Set REPORT value
     * @throws \InvalidArgumentException
     * @param \StructType\REPORT[] $rEPORT
     * @return \StructType\GetEArchiveReportResponse
     */
    public function setREPORT(array $rEPORT = array())
    {
        foreach ($rEPORT as $getEArchiveReportResponseREPORTItem) {
            // validation for constraint: itemType
            if (!$getEArchiveReportResponseREPORTItem instanceof \StructType\REPORT) {
                throw new \InvalidArgumentException(sprintf('The REPORT property can only contain items of \StructType\REPORT, "%s" given', is_object($getEArchiveReportResponseREPORTItem) ? get_class($getEArchiveReportResponseREPORTItem) : gettype($getEArchiveReportResponseREPORTItem)), __LINE__);
            }
        }
        $this->REPORT = $rEPORT;
        return $this;
    }
    /**
     * Add item to REPORT value
     * @throws \InvalidArgumentException
     * @param \StructType\REPORT $item
     * @return \StructType\GetEArchiveReportResponse
     */
    public function addToREPORT(\StructType\REPORT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\REPORT) {
            throw new \InvalidArgumentException(sprintf('The REPORT property can only contain items of \StructType\REPORT, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->REPORT[] = $item;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\REPORT_INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\REPORT_INVOICE[] $iNVOICE
     * @return \StructType\GetEArchiveReportResponse
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        foreach ($iNVOICE as $getEArchiveReportResponseINVOICEItem) {
            // validation for constraint: itemType
            if (!$getEArchiveReportResponseINVOICEItem instanceof \StructType\REPORT_INVOICE) {
                throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\REPORT_INVOICE, "%s" given', is_object($getEArchiveReportResponseINVOICEItem) ? get_class($getEArchiveReportResponseINVOICEItem) : gettype($getEArchiveReportResponseINVOICEItem)), __LINE__);
            }
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\REPORT_INVOICE $item
     * @return \StructType\GetEArchiveReportResponse
     */
    public function addToINVOICE(\StructType\REPORT_INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\REPORT_INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of \StructType\REPORT_INVOICE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_RETURN value
     * @return \StructType\REQUEST_RETURNType|null
     */
    public function getREQUEST_RETURN()
    {
        return $this->REQUEST_RETURN;
    }
    /**
     * Set REQUEST_RETURN value
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @return \StructType\GetEArchiveReportResponse
     */
    public function setREQUEST_RETURN(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null)
    {
        $this->REQUEST_RETURN = $rEQUEST_RETURN;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\GetEArchiveReportResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEArchiveReportResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
