<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Elements StructType
 * @subpackage Structs
 */
class Elements extends AbstractStructBase
{
    /**
     * The ElementList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Base64Binary[]
     */
    public $ElementList;
    /**
     * The ElementType
     * @var string
     */
    public $ElementType;
    /**
     * The ElementCount
     * @var int
     */
    public $ElementCount;
    /**
     * Constructor method for Elements
     * @uses Elements::setElementList()
     * @uses Elements::setElementType()
     * @uses Elements::setElementCount()
     * @param \StructType\Base64Binary[] $elementList
     * @param string $elementType
     * @param int $elementCount
     */
    public function __construct(array $elementList = array(), $elementType = null, $elementCount = null)
    {
        $this
            ->setElementList($elementList)
            ->setElementType($elementType)
            ->setElementCount($elementCount);
    }
    /**
     * Get ElementList value
     * @return \StructType\Base64Binary[]
     */
    public function getElementList()
    {
        return $this->ElementList;
    }
    /**
     * Set ElementList value
     * @throws \InvalidArgumentException
     * @param \StructType\Base64Binary[] $elementList
     * @return \StructType\Elements
     */
    public function setElementList(array $elementList = array())
    {
        foreach ($elementList as $elementsElementListItem) {
            // validation for constraint: itemType
            if (!$elementsElementListItem instanceof \StructType\Base64Binary) {
                throw new \InvalidArgumentException(sprintf('The ElementList property can only contain items of \StructType\Base64Binary, "%s" given', is_object($elementsElementListItem) ? get_class($elementsElementListItem) : gettype($elementsElementListItem)), __LINE__);
            }
        }
        $this->ElementList = $elementList;
        return $this;
    }
    /**
     * Add item to ElementList value
     * @throws \InvalidArgumentException
     * @param \StructType\Base64Binary $item
     * @return \StructType\Elements
     */
    public function addToElementList(\StructType\Base64Binary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Base64Binary) {
            throw new \InvalidArgumentException(sprintf('The ElementList property can only contain items of \StructType\Base64Binary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ElementList[] = $item;
        return $this;
    }
    /**
     * Get ElementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->ElementType;
    }
    /**
     * Set ElementType value
     * @param string $elementType
     * @return \StructType\Elements
     */
    public function setElementType($elementType = null)
    {
        // validation for constraint: string
        if (!is_null($elementType) && !is_string($elementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($elementType)), __LINE__);
        }
        $this->ElementType = $elementType;
        return $this;
    }
    /**
     * Get ElementCount value
     * @return int|null
     */
    public function getElementCount()
    {
        return $this->ElementCount;
    }
    /**
     * Set ElementCount value
     * @param int $elementCount
     * @return \StructType\Elements
     */
    public function setElementCount($elementCount = null)
    {
        // validation for constraint: int
        if (!is_null($elementCount) && !is_numeric($elementCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($elementCount)), __LINE__);
        }
        $this->ElementCount = $elementCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Elements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
