<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DOCUMENT StructType
 * @subpackage Structs
 */
class DOCUMENT extends AbstractStructBase
{
    /**
     * The DONEM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DONEM;
    /**
     * The DOC_NAME
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DOC_NAME;
    /**
     * The DOC_TYPE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DOC_TYPE;
    /**
     * The SUBE_NO
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SUBE_NO;
    /**
     * Constructor method for DOCUMENT
     * @uses DOCUMENT::setDONEM()
     * @uses DOCUMENT::setDOC_NAME()
     * @uses DOCUMENT::setDOC_TYPE()
     * @uses DOCUMENT::setSUBE_NO()
     * @param string $dONEM
     * @param string $dOC_NAME
     * @param string $dOC_TYPE
     * @param string $sUBE_NO
     */
    public function __construct($dONEM = null, $dOC_NAME = null, $dOC_TYPE = null, $sUBE_NO = null)
    {
        $this
            ->setDONEM($dONEM)
            ->setDOC_NAME($dOC_NAME)
            ->setDOC_TYPE($dOC_TYPE)
            ->setSUBE_NO($sUBE_NO);
    }
    /**
     * Get DONEM value
     * @return string
     */
    public function getDONEM()
    {
        return $this->DONEM;
    }
    /**
     * Set DONEM value
     * @param string $dONEM
     * @return \StructType\DOCUMENT
     */
    public function setDONEM($dONEM = null)
    {
        // validation for constraint: string
        if (!is_null($dONEM) && !is_string($dONEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dONEM)), __LINE__);
        }
        $this->DONEM = $dONEM;
        return $this;
    }
    /**
     * Get DOC_NAME value
     * @return string
     */
    public function getDOC_NAME()
    {
        return $this->DOC_NAME;
    }
    /**
     * Set DOC_NAME value
     * @param string $dOC_NAME
     * @return \StructType\DOCUMENT
     */
    public function setDOC_NAME($dOC_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($dOC_NAME) && !is_string($dOC_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dOC_NAME)), __LINE__);
        }
        $this->DOC_NAME = $dOC_NAME;
        return $this;
    }
    /**
     * Get DOC_TYPE value
     * @return string
     */
    public function getDOC_TYPE()
    {
        return $this->DOC_TYPE;
    }
    /**
     * Set DOC_TYPE value
     * @uses \EnumType\DOC_TYPE::valueIsValid()
     * @uses \EnumType\DOC_TYPE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dOC_TYPE
     * @return \StructType\DOCUMENT
     */
    public function setDOC_TYPE($dOC_TYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DOC_TYPE::valueIsValid($dOC_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dOC_TYPE, implode(', ', \EnumType\DOC_TYPE::getValidValues())), __LINE__);
        }
        $this->DOC_TYPE = $dOC_TYPE;
        return $this;
    }
    /**
     * Get SUBE_NO value
     * @return string|null
     */
    public function getSUBE_NO()
    {
        return $this->SUBE_NO;
    }
    /**
     * Set SUBE_NO value
     * @param string $sUBE_NO
     * @return \StructType\DOCUMENT
     */
    public function setSUBE_NO($sUBE_NO = null)
    {
        // validation for constraint: string
        if (!is_null($sUBE_NO) && !is_string($sUBE_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUBE_NO)), __LINE__);
        }
        $this->SUBE_NO = $sUBE_NO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DOCUMENT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
