<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CRLRefType StructType
 * @subpackage Structs
 */
class CRLRefType extends AbstractStructBase
{
    /**
     * The DigestAlgAndValue
     * @var \StructType\DigestAlgAndValueType
     */
    public $DigestAlgAndValue;
    /**
     * The CRLIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CRLIdentifierType
     */
    public $CRLIdentifier;
    /**
     * Constructor method for CRLRefType
     * @uses CRLRefType::setDigestAlgAndValue()
     * @uses CRLRefType::setCRLIdentifier()
     * @param \StructType\DigestAlgAndValueType $digestAlgAndValue
     * @param \StructType\CRLIdentifierType $cRLIdentifier
     */
    public function __construct(\StructType\DigestAlgAndValueType $digestAlgAndValue = null, \StructType\CRLIdentifierType $cRLIdentifier = null)
    {
        $this
            ->setDigestAlgAndValue($digestAlgAndValue)
            ->setCRLIdentifier($cRLIdentifier);
    }
    /**
     * Get DigestAlgAndValue value
     * @return \StructType\DigestAlgAndValueType|null
     */
    public function getDigestAlgAndValue()
    {
        return $this->DigestAlgAndValue;
    }
    /**
     * Set DigestAlgAndValue value
     * @param \StructType\DigestAlgAndValueType $digestAlgAndValue
     * @return \StructType\CRLRefType
     */
    public function setDigestAlgAndValue(\StructType\DigestAlgAndValueType $digestAlgAndValue = null)
    {
        $this->DigestAlgAndValue = $digestAlgAndValue;
        return $this;
    }
    /**
     * Get CRLIdentifier value
     * @return \StructType\CRLIdentifierType|null
     */
    public function getCRLIdentifier()
    {
        return $this->CRLIdentifier;
    }
    /**
     * Set CRLIdentifier value
     * @param \StructType\CRLIdentifierType $cRLIdentifier
     * @return \StructType\CRLRefType
     */
    public function setCRLIdentifier(\StructType\CRLIdentifierType $cRLIdentifier = null)
    {
        $this->CRLIdentifier = $cRLIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CRLRefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
