<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for baslikType StructType
 * @subpackage Structs
 */
class BaslikType extends AbstractStructBase
{
    /**
     * The versiyon
     * @var string
     */
    public $versiyon;
    /**
     * The mukellef
     * @var \StructType\VknTcknType
     */
    public $mukellef;
    /**
     * The hazirlayan
     * @var \StructType\VknTcknType
     */
    public $hazirlayan;
    /**
     * The raporNo
     * Meta informations extracted from the WSDL
     * - length: 36
     * - pattern: [a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}
     * @var string
     */
    public $raporNo;
    /**
     * The donemBaslangicTarihi
     * @var string
     */
    public $donemBaslangicTarihi;
    /**
     * The donemBitisTarihi
     * @var string
     */
    public $donemBitisTarihi;
    /**
     * The bolumBaslangicTarihi
     * @var string
     */
    public $bolumBaslangicTarihi;
    /**
     * The bolumBitisTarihi
     * @var string
     */
    public $bolumBitisTarihi;
    /**
     * The bolumNo
     * @var int
     */
    public $bolumNo;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * Constructor method for baslikType
     * @uses BaslikType::setVersiyon()
     * @uses BaslikType::setMukellef()
     * @uses BaslikType::setHazirlayan()
     * @uses BaslikType::setRaporNo()
     * @uses BaslikType::setDonemBaslangicTarihi()
     * @uses BaslikType::setDonemBitisTarihi()
     * @uses BaslikType::setBolumBaslangicTarihi()
     * @uses BaslikType::setBolumBitisTarihi()
     * @uses BaslikType::setBolumNo()
     * @uses BaslikType::setSignature()
     * @param string $versiyon
     * @param \StructType\VknTcknType $mukellef
     * @param \StructType\VknTcknType $hazirlayan
     * @param string $raporNo
     * @param string $donemBaslangicTarihi
     * @param string $donemBitisTarihi
     * @param string $bolumBaslangicTarihi
     * @param string $bolumBitisTarihi
     * @param int $bolumNo
     * @param \StructType\SignatureType $signature
     */
    public function __construct($versiyon = null, \StructType\VknTcknType $mukellef = null, \StructType\VknTcknType $hazirlayan = null, $raporNo = null, $donemBaslangicTarihi = null, $donemBitisTarihi = null, $bolumBaslangicTarihi = null, $bolumBitisTarihi = null, $bolumNo = null, \StructType\SignatureType $signature = null)
    {
        $this
            ->setVersiyon($versiyon)
            ->setMukellef($mukellef)
            ->setHazirlayan($hazirlayan)
            ->setRaporNo($raporNo)
            ->setDonemBaslangicTarihi($donemBaslangicTarihi)
            ->setDonemBitisTarihi($donemBitisTarihi)
            ->setBolumBaslangicTarihi($bolumBaslangicTarihi)
            ->setBolumBitisTarihi($bolumBitisTarihi)
            ->setBolumNo($bolumNo)
            ->setSignature($signature);
    }
    /**
     * Get versiyon value
     * @return string|null
     */
    public function getVersiyon()
    {
        return $this->versiyon;
    }
    /**
     * Set versiyon value
     * @param string $versiyon
     * @return \StructType\BaslikType
     */
    public function setVersiyon($versiyon = null)
    {
        // validation for constraint: string
        if (!is_null($versiyon) && !is_string($versiyon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versiyon)), __LINE__);
        }
        $this->versiyon = $versiyon;
        return $this;
    }
    /**
     * Get mukellef value
     * @return \StructType\VknTcknType|null
     */
    public function getMukellef()
    {
        return $this->mukellef;
    }
    /**
     * Set mukellef value
     * @param \StructType\VknTcknType $mukellef
     * @return \StructType\BaslikType
     */
    public function setMukellef(\StructType\VknTcknType $mukellef = null)
    {
        $this->mukellef = $mukellef;
        return $this;
    }
    /**
     * Get hazirlayan value
     * @return \StructType\VknTcknType|null
     */
    public function getHazirlayan()
    {
        return $this->hazirlayan;
    }
    /**
     * Set hazirlayan value
     * @param \StructType\VknTcknType $hazirlayan
     * @return \StructType\BaslikType
     */
    public function setHazirlayan(\StructType\VknTcknType $hazirlayan = null)
    {
        $this->hazirlayan = $hazirlayan;
        return $this;
    }
    /**
     * Get raporNo value
     * @return string|null
     */
    public function getRaporNo()
    {
        return $this->raporNo;
    }
    /**
     * Set raporNo value
     * @param string $raporNo
     * @return \StructType\BaslikType
     */
    public function setRaporNo($raporNo = null)
    {
        // validation for constraint: length
        if ((is_scalar($raporNo) && strlen($raporNo) !== 36) || (is_array($raporNo) && count($raporNo) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($raporNo) && !preg_match('/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/', $raporNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}", "%s" given', var_export($raporNo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($raporNo) && !is_string($raporNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($raporNo)), __LINE__);
        }
        $this->raporNo = $raporNo;
        return $this;
    }
    /**
     * Get donemBaslangicTarihi value
     * @return string|null
     */
    public function getDonemBaslangicTarihi()
    {
        return $this->donemBaslangicTarihi;
    }
    /**
     * Set donemBaslangicTarihi value
     * @param string $donemBaslangicTarihi
     * @return \StructType\BaslikType
     */
    public function setDonemBaslangicTarihi($donemBaslangicTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($donemBaslangicTarihi) && !is_string($donemBaslangicTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($donemBaslangicTarihi)), __LINE__);
        }
        $this->donemBaslangicTarihi = $donemBaslangicTarihi;
        return $this;
    }
    /**
     * Get donemBitisTarihi value
     * @return string|null
     */
    public function getDonemBitisTarihi()
    {
        return $this->donemBitisTarihi;
    }
    /**
     * Set donemBitisTarihi value
     * @param string $donemBitisTarihi
     * @return \StructType\BaslikType
     */
    public function setDonemBitisTarihi($donemBitisTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($donemBitisTarihi) && !is_string($donemBitisTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($donemBitisTarihi)), __LINE__);
        }
        $this->donemBitisTarihi = $donemBitisTarihi;
        return $this;
    }
    /**
     * Get bolumBaslangicTarihi value
     * @return string|null
     */
    public function getBolumBaslangicTarihi()
    {
        return $this->bolumBaslangicTarihi;
    }
    /**
     * Set bolumBaslangicTarihi value
     * @param string $bolumBaslangicTarihi
     * @return \StructType\BaslikType
     */
    public function setBolumBaslangicTarihi($bolumBaslangicTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($bolumBaslangicTarihi) && !is_string($bolumBaslangicTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bolumBaslangicTarihi)), __LINE__);
        }
        $this->bolumBaslangicTarihi = $bolumBaslangicTarihi;
        return $this;
    }
    /**
     * Get bolumBitisTarihi value
     * @return string|null
     */
    public function getBolumBitisTarihi()
    {
        return $this->bolumBitisTarihi;
    }
    /**
     * Set bolumBitisTarihi value
     * @param string $bolumBitisTarihi
     * @return \StructType\BaslikType
     */
    public function setBolumBitisTarihi($bolumBitisTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($bolumBitisTarihi) && !is_string($bolumBitisTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bolumBitisTarihi)), __LINE__);
        }
        $this->bolumBitisTarihi = $bolumBitisTarihi;
        return $this;
    }
    /**
     * Get bolumNo value
     * @return int|null
     */
    public function getBolumNo()
    {
        return $this->bolumNo;
    }
    /**
     * Set bolumNo value
     * @param int $bolumNo
     * @return \StructType\BaslikType
     */
    public function setBolumNo($bolumNo = null)
    {
        // validation for constraint: int
        if (!is_null($bolumNo) && !is_numeric($bolumNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bolumNo)), __LINE__);
        }
        $this->bolumNo = $bolumNo;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\BaslikType
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaslikType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
