<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Copy ServiceType
 * @subpackage Services
 */
class Copy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CopyToArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArchiveInvoiceCopyRequest $request
     * @return \StructType\ArchiveInvoiceCopyResponse|bool
     */
    public function CopyToArchive(\StructType\ArchiveInvoiceCopyRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->CopyToArchive($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ArchiveInvoiceCopyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
