<?php

namespace EnumType;

/**
 * This class stands for QualifierType EnumType
 * @subpackage Enumerations
 */
class QualifierType
{
    /**
     * Constant for value 'OIDAsURI'
     * @return string 'OIDAsURI'
     */
    const VALUE_OIDAS_URI = 'OIDAsURI';
    /**
     * Constant for value 'OIDAsURN'
     * @return string 'OIDAsURN'
     */
    const VALUE_OIDAS_URN = 'OIDAsURN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OIDAS_URI
     * @uses self::VALUE_OIDAS_URN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OIDAS_URI,
            self::VALUE_OIDAS_URN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
