<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PRODUCT_LIST StructType
 * @subpackage Structs
 */
class PRODUCT_LIST extends AbstractStructBase
{
    /**
     * The PRODUCT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PRODUCT;
    /**
     * Constructor method for PRODUCT_LIST
     * @uses PRODUCT_LIST::setPRODUCT()
     * @param string[] $pRODUCT
     */
    public function __construct(array $pRODUCT = array())
    {
        $this
            ->setPRODUCT($pRODUCT);
    }
    /**
     * Get PRODUCT value
     * @return string[]|null
     */
    public function getPRODUCT()
    {
        return $this->PRODUCT;
    }
    /**
     * Set PRODUCT value
     * @uses \EnumType\PRODUCT::valueIsValid()
     * @uses \EnumType\PRODUCT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $pRODUCT
     * @return \StructType\PRODUCT_LIST
     */
    public function setPRODUCT(array $pRODUCT = array())
    {
        $invalidValues = array();
        foreach ($pRODUCT as $pRODUCT_LISTPRODUCTItem) {
            if (!\EnumType\PRODUCT::valueIsValid($pRODUCT_LISTPRODUCTItem)) {
                $invalidValues[] = var_export($pRODUCT_LISTPRODUCTItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\PRODUCT::getValidValues())), __LINE__);
        }
        $this->PRODUCT = $pRODUCT;
        return $this;
    }
    /**
     * Add item to PRODUCT value
     * @uses \EnumType\PRODUCT::valueIsValid()
     * @uses \EnumType\PRODUCT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PRODUCT_LIST
     */
    public function addToPRODUCT($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PRODUCT::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\PRODUCT::getValidValues())), __LINE__);
        }
        $this->PRODUCT[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PRODUCT_LIST
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
