<?php

namespace EnumType;

/**
 * This class stands for PRODUCT EnumType
 * @subpackage Enumerations
 */
class PRODUCT
{
    /**
     * Constant for value 'EINVOICE'
     * @return string 'EINVOICE'
     */
    const VALUE_EINVOICE = 'EINVOICE';
    /**
     * Constant for value 'EARCHIVE'
     * @return string 'EARCHIVE'
     */
    const VALUE_EARCHIVE = 'EARCHIVE';
    /**
     * Constant for value 'EDESPATCH'
     * @return string 'EDESPATCH'
     */
    const VALUE_EDESPATCH = 'EDESPATCH';
    /**
     * Constant for value 'CREDITNOTE'
     * @return string 'CREDITNOTE'
     */
    const VALUE_CREDITNOTE = 'CREDITNOTE';
    /**
     * Constant for value 'RECONCILIATION'
     * @return string 'RECONCILIATION'
     */
    const VALUE_RECONCILIATION = 'RECONCILIATION';
    /**
     * Constant for value 'CONNECTOR'
     * @return string 'CONNECTOR'
     */
    const VALUE_CONNECTOR = 'CONNECTOR';
    /**
     * Constant for value 'ELEDGER'
     * @return string 'ELEDGER'
     */
    const VALUE_ELEDGER = 'ELEDGER';
    /**
     * Constant for value 'ELEDGERARCHIVE'
     * @return string 'ELEDGERARCHIVE'
     */
    const VALUE_ELEDGERARCHIVE = 'ELEDGERARCHIVE';
    /**
     * Constant for value 'EINVOICEARCHIVE'
     * @return string 'EINVOICEARCHIVE'
     */
    const VALUE_EINVOICEARCHIVE = 'EINVOICEARCHIVE';
    /**
     * Constant for value 'ESMM'
     * @return string 'ESMM'
     */
    const VALUE_ESMM = 'ESMM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EINVOICE
     * @uses self::VALUE_EARCHIVE
     * @uses self::VALUE_EDESPATCH
     * @uses self::VALUE_CREDITNOTE
     * @uses self::VALUE_RECONCILIATION
     * @uses self::VALUE_CONNECTOR
     * @uses self::VALUE_ELEDGER
     * @uses self::VALUE_ELEDGERARCHIVE
     * @uses self::VALUE_EINVOICEARCHIVE
     * @uses self::VALUE_ESMM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EINVOICE,
            self::VALUE_EARCHIVE,
            self::VALUE_EDESPATCH,
            self::VALUE_CREDITNOTE,
            self::VALUE_RECONCILIATION,
            self::VALUE_CONNECTOR,
            self::VALUE_ELEDGER,
            self::VALUE_ELEDGERARCHIVE,
            self::VALUE_EINVOICEARCHIVE,
            self::VALUE_ESMM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
